/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.CapabilitiesState;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.NeutralFiguresState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.game.state.PlayersState;
import com.jcloisterzone.game.state.mixins.ActionsMixin;
import com.jcloisterzone.game.state.mixins.BoardMixin;
import com.jcloisterzone.game.state.mixins.CapabilitiesMixin;
import com.jcloisterzone.game.state.mixins.EventsMixin;
import com.jcloisterzone.game.state.mixins.FlagsMixin;
import com.jcloisterzone.game.state.mixins.PlacementsMixin;
import com.jcloisterzone.game.state.mixins.PlayersMixin;
import com.jcloisterzone.game.state.mixins.RulesMixin;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Queue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import java.io.Serializable;
import java.util.function.Function;

public class GameState
implements ActionsMixin,
BoardMixin,
RulesMixin,
CapabilitiesMixin,
PlayersMixin,
EventsMixin,
FlagsMixin,
PlacementsMixin,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Rule, Object> rules;
    private final CapabilitiesState capabilities;
    private final PlayersState players;
    private final TilePack tilePack;
    private final Tile drawnTile;
    private final LinkedHashMap<Position, PlacedTile> placedTiles;
    private final List<Tile> discardedTiles;
    private final Map<FeaturePointer, Feature> featureMap;
    private final NeutralFiguresState neutralFigures;
    private final LinkedHashMap<Meeple, FeaturePointer> deployedMeeples;
    private final Set<Flag> flags;
    private final ActionsState playerActions;
    private final Queue<PlayEvent> events;
    private final Class<? extends Phase> phase;
    private final int turnNumber;

    public static GameState createInitial(Map<Rule, Object> rules, Seq<Capability<?>> capabilities, Array<Player> players, int turnPlayerIndex) {
        return new GameState(rules, CapabilitiesState.createInitial(capabilities), PlayersState.createInitial(players, turnPlayerIndex), null, null, LinkedHashMap.empty(), List.empty(), HashMap.empty(), new NeutralFiguresState(), LinkedHashMap.empty(), null, HashSet.empty(), Queue.empty(), null, 1);
    }

    public GameState(Map<Rule, Object> rules, CapabilitiesState capabilities, PlayersState players, TilePack tilePack, Tile drawnTile, LinkedHashMap<Position, PlacedTile> placedTiles, List<Tile> discardedTiles, Map<FeaturePointer, Feature> featureMap, NeutralFiguresState neutralFigures, LinkedHashMap<Meeple, FeaturePointer> deployedMeeples, ActionsState playerActions, Set<Flag> flags, Queue<PlayEvent> events, Class<? extends Phase> phase, int turnNumber) {
        this.rules = rules;
        this.capabilities = capabilities;
        this.players = players;
        this.tilePack = tilePack;
        this.drawnTile = drawnTile;
        this.placedTiles = placedTiles;
        this.discardedTiles = discardedTiles;
        this.featureMap = featureMap;
        this.neutralFigures = neutralFigures;
        this.deployedMeeples = deployedMeeples;
        this.playerActions = playerActions;
        this.flags = flags;
        this.events = events;
        this.phase = phase;
        this.turnNumber = turnNumber;
    }

    @Override
    public GameState setCapabilities(CapabilitiesState capabilities) {
        if (capabilities == this.capabilities) {
            return this;
        }
        return new GameState(this.rules, capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState setPlayers(PlayersState players) {
        if (players == this.players) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    public GameState setTilePack(TilePack tilePack) {
        if (tilePack == this.tilePack) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    public GameState mapTilePack(Function<TilePack, TilePack> fn) {
        return this.setTilePack(fn.apply(this.tilePack));
    }

    public GameState setDrawnTile(Tile drawnTile) {
        if (drawnTile == this.drawnTile) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState setPlacedTiles(LinkedHashMap<Position, PlacedTile> placedTiles) {
        if (placedTiles == this.placedTiles) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState setFeatureMap(Map<FeaturePointer, Feature> featureMap) {
        if (featureMap == this.featureMap) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState mapFeatureMap(Function<Map<FeaturePointer, Feature>, Map<FeaturePointer, Feature>> fn) {
        return this.setFeatureMap(fn.apply(this.featureMap));
    }

    public GameState setDiscardedTiles(List<Tile> discardedTiles) {
        if (discardedTiles == this.discardedTiles) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    public GameState setNeutralFigures(NeutralFiguresState neutralFigures) {
        if (neutralFigures == this.neutralFigures) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    public GameState mapNeutralFigures(Function<NeutralFiguresState, NeutralFiguresState> fn) {
        return this.setNeutralFigures(fn.apply(this.neutralFigures));
    }

    public GameState setDeployedMeeples(LinkedHashMap<Meeple, FeaturePointer> deployedMeeples) {
        if (deployedMeeples == this.deployedMeeples) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, deployedMeeples, this.playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState setPlayerActions(ActionsState playerActions) {
        if (playerActions == this.playerActions) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, playerActions, this.flags, this.events, this.phase, this.turnNumber);
    }

    public GameState mapPlayerActions(Function<ActionsState, ActionsState> fn) {
        return this.setPlayerActions(fn.apply(this.playerActions));
    }

    @Override
    public GameState setFlags(Set<Flag> flags) {
        if (flags == this.flags) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, flags, this.events, this.phase, this.turnNumber);
    }

    @Override
    public GameState setEvents(Queue<PlayEvent> events) {
        if (events == this.events) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, events, this.phase, this.turnNumber);
    }

    public GameState setPhase(Class<? extends Phase> phase) {
        if (phase == this.phase) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, phase, this.turnNumber);
    }

    public GameState setTurnNumber(int turnNumber) {
        if (turnNumber == this.turnNumber) {
            return this;
        }
        return new GameState(this.rules, this.capabilities, this.players, this.tilePack, this.drawnTile, this.placedTiles, this.discardedTiles, this.featureMap, this.neutralFigures, this.deployedMeeples, this.playerActions, this.flags, this.events, this.phase, turnNumber);
    }

    @Override
    public Map<Rule, Object> getRules() {
        return this.rules;
    }

    @Override
    public CapabilitiesState getCapabilities() {
        return this.capabilities;
    }

    @Override
    public PlayersState getPlayers() {
        return this.players;
    }

    public TilePack getTilePack() {
        return this.tilePack;
    }

    public Tile getDrawnTile() {
        return this.drawnTile;
    }

    @Override
    public LinkedHashMap<Position, PlacedTile> getPlacedTiles() {
        return this.placedTiles;
    }

    public List<Tile> getDiscardedTiles() {
        return this.discardedTiles;
    }

    @Override
    public Map<FeaturePointer, Feature> getFeatureMap() {
        return this.featureMap;
    }

    public NeutralFiguresState getNeutralFigures() {
        return this.neutralFigures;
    }

    public LinkedHashMap<Meeple, FeaturePointer> getDeployedMeeples() {
        return this.deployedMeeples;
    }

    @Override
    public ActionsState getPlayerActions() {
        return this.playerActions;
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public Queue<PlayEvent> getEvents() {
        return this.events;
    }

    public Class<? extends Phase> getPhase() {
        return this.phase;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }
}

