/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.board.TilePackBuilder;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.PlayerTurnEvent;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.MeepleIdProvider;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.PlaceTile;
import io.vavr.Predicates;
import io.vavr.collection.Array;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameStateBuilder {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GameSetup setup;
    private final PlayerSlot[] slots;
    private final Config config;
    private Array<Player> players;
    private Seq<PlacedTile> preplacedTiles;
    private Map<String, Object> gameAnnotations;
    private GameState state;

    public GameStateBuilder(GameSetup setup, PlayerSlot[] slots, Config config) {
        this.setup = setup;
        this.slots = slots;
        this.config = config;
    }

    public GameState createInitialState() {
        List<Capability<?>> capabilities = this.createCapabilities(this.setup.getCapabilities());
        this.createPlayers();
        this.state = GameState.createInitial(this.setup.getRules(), capabilities, this.players, 0);
        this.state = this.state.mapPlayers(ps -> ps.setFollowers((Array<Seq<Follower>>)this.players.map(p -> this.createPlayerFollowers((Player)p, capabilities))).setSpecialMeeples((Array<Seq<Special>>)this.players.map(p -> this.createPlayerSpecialMeeples((Player)p, capabilities))));
        this.createTilePack();
        for (Capability capability : this.state.getCapabilities().toSeq()) {
            this.state = capability.onStartGame(this.state);
        }
        this.state = this.processGameAnnotations(this.state);
        return this.state;
    }

    public GameState createReadyState(GameState state) {
        for (PlacedTile pt : this.preplacedTiles) {
            state = new PlaceTile(pt.getTile(), pt.getPosition(), pt.getRotation()).apply(state);
        }
        state = state.appendEvent(new PlayerTurnEvent(PlayEvent.PlayEventMeta.createWithoutPlayer(), state.getTurnPlayer()));
        return state;
    }

    private GameState processGameAnnotations(GameState state) {
        if (this.gameAnnotations == null) {
            return state;
        }
        Map tilePackAnnotation = (Map)this.gameAnnotations.get("tilePack");
        if (tilePackAnnotation != null) {
            try {
                String clsName = (String)tilePackAnnotation.get("className");
                Object params = tilePackAnnotation.get("params");
                TilePack replacement = (TilePack)Class.forName(clsName).getConstructor(LinkedHashMap.class, Map.class).newInstance(state.getTilePack().getGroups(), params);
                state = state.setTilePack(replacement);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return state;
    }

    private void createPlayers() {
        this.players = Stream.ofAll(Arrays.asList(this.slots)).filter(Predicates.isNotNull()).filter(PlayerSlot::isOccupied).sortBy(PlayerSlot::getSerial).foldLeft(Array.empty(), (arr, slot) -> arr.append(new Player(slot.getNickname(), arr.size(), (PlayerSlot)slot)));
        if (this.players.isEmpty()) {
            throw new IllegalStateException("No players in game");
        }
    }

    private void createTilePack() {
        TilePackBuilder tilePackBuilder = new TilePackBuilder();
        tilePackBuilder.setGameState(this.state);
        tilePackBuilder.setConfig(this.config);
        tilePackBuilder.setExpansions(this.setup.getExpansions());
        TilePackBuilder.Tiles tiles = tilePackBuilder.createTilePack();
        TilePack tilePack = tiles.getTilePack();
        this.state = this.state.setTilePack(tilePack);
        this.preplacedTiles = tiles.getPreplacedTiles();
    }

    private Capability<?> createCapabilityInstance(Class<? extends Capability<?>> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + clazz.getSimpleName(), e);
        }
    }

    public List<Capability<?>> createCapabilities(Set<Class<? extends Capability<?>>> classes) {
        return List.narrow(classes.map(this::createCapabilityInstance).toList());
    }

    private List<Follower> createPlayerFollowers(Player p, Seq<Capability<?>> capabilities) {
        MeepleIdProvider idProvider = new MeepleIdProvider(p);
        List<Follower> followers = List.empty();
        followers = followers.appendAll((Iterable)capabilities.flatMap(c -> c.createPlayerFollowers(p, idProvider)));
        return followers;
    }

    public Seq<Special> createPlayerSpecialMeeples(Player p, Seq<Capability<?>> capabilities) {
        MeepleIdProvider idProvider = new MeepleIdProvider(p);
        return capabilities.flatMap(c -> c.createPlayerSpecialMeeples(p, idProvider));
    }

    public Map<String, Object> getGameAnnotations() {
        return this.gameAnnotations;
    }

    public void setGameAnnotations(Map<String, Object> gameAnnotations) {
        this.gameAnnotations = gameAnnotations;
    }
}

