/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.figure.neutral.Count;
import com.jcloisterzone.figure.neutral.Dragon;
import com.jcloisterzone.figure.neutral.Fairy;
import com.jcloisterzone.figure.neutral.Mage;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.figure.neutral.Witch;
import io.vavr.collection.LinkedHashMap;
import java.io.Serializable;

public class NeutralFiguresState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Dragon dragon;
    private final Fairy fairy;
    private final Mage mage;
    private final Witch witch;
    private final Count count;
    private final LinkedHashMap<NeutralFigure<?>, BoardPointer> deployedNeutralFigures;

    public NeutralFiguresState() {
        this(null, null, null, null, null, LinkedHashMap.empty());
    }

    public NeutralFiguresState(Dragon dragon, Fairy fairy, Mage mage, Witch witch, Count count, LinkedHashMap<NeutralFigure<?>, BoardPointer> deployedNeutralFigures) {
        this.dragon = dragon;
        this.fairy = fairy;
        this.mage = mage;
        this.witch = witch;
        this.count = count;
        this.deployedNeutralFigures = deployedNeutralFigures;
    }

    public NeutralFiguresState setDragon(Dragon dragon) {
        return new NeutralFiguresState(dragon, this.fairy, this.mage, this.witch, this.count, this.deployedNeutralFigures);
    }

    public NeutralFiguresState setFairy(Fairy fairy) {
        return new NeutralFiguresState(this.dragon, fairy, this.mage, this.witch, this.count, this.deployedNeutralFigures);
    }

    public NeutralFiguresState setMage(Mage mage) {
        return new NeutralFiguresState(this.dragon, this.fairy, mage, this.witch, this.count, this.deployedNeutralFigures);
    }

    public NeutralFiguresState setWitch(Witch witch) {
        return new NeutralFiguresState(this.dragon, this.fairy, this.mage, witch, this.count, this.deployedNeutralFigures);
    }

    public NeutralFiguresState setCount(Count count) {
        return new NeutralFiguresState(this.dragon, this.fairy, this.mage, this.witch, count, this.deployedNeutralFigures);
    }

    public NeutralFiguresState setDeployedNeutralFigures(LinkedHashMap<NeutralFigure<?>, BoardPointer> deployedNeutralFigures) {
        return new NeutralFiguresState(this.dragon, this.fairy, this.mage, this.witch, this.count, deployedNeutralFigures);
    }

    public NeutralFigure<?> getById(String figureId) {
        if (this.dragon != null && figureId.equals(this.dragon.getId())) {
            return this.dragon;
        }
        if (this.fairy != null && figureId.equals(this.fairy.getId())) {
            return this.fairy;
        }
        if (this.mage != null && figureId.equals(this.mage.getId())) {
            return this.mage;
        }
        if (this.witch != null && figureId.equals(this.witch.getId())) {
            return this.witch;
        }
        if (this.count != null && figureId.equals(this.count.getId())) {
            return this.count;
        }
        return null;
    }

    public Dragon getDragon() {
        return this.dragon;
    }

    public Position getDragonDeployment() {
        return (Position)this.deployedNeutralFigures.get(this.dragon).getOrNull();
    }

    public Fairy getFairy() {
        return this.fairy;
    }

    public BoardPointer getFairyDeployment() {
        return (BoardPointer)this.deployedNeutralFigures.get(this.fairy).getOrNull();
    }

    public Mage getMage() {
        return this.mage;
    }

    public FeaturePointer getMageDeployment() {
        return (FeaturePointer)this.deployedNeutralFigures.get(this.mage).getOrNull();
    }

    public Witch getWitch() {
        return this.witch;
    }

    public FeaturePointer getWitchDeployment() {
        return (FeaturePointer)this.deployedNeutralFigures.get(this.witch).getOrNull();
    }

    public Count getCount() {
        return this.count;
    }

    public FeaturePointer getCountDeployment() {
        return (FeaturePointer)this.deployedNeutralFigures.get(this.count).getOrNull();
    }

    public LinkedHashMap<NeutralFigure<?>, BoardPointer> getDeployedNeutralFigures() {
        return this.deployedNeutralFigures;
    }
}

