/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state.mixins;

import com.jcloisterzone.board.EdgePattern;
import com.jcloisterzone.board.EdgeType;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.game.state.mixins.BoardMixin;
import com.jcloisterzone.game.state.mixins.CapabilitiesMixin;
import com.jcloisterzone.game.state.mixins.PlayersMixin;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import java.util.ArrayList;
import java.util.HashSet;

public interface PlacementsMixin
extends BoardMixin,
PlayersMixin,
CapabilitiesMixin {
    default public Stream<Tuple2<Position, EdgePattern>> getAvailablePlacements() {
        HashSet used = new HashSet();
        LinkedHashMap<Position, PlacedTile> placedTiles = this.getPlacedTiles();
        if (placedTiles.isEmpty()) {
            return Stream.of(new Tuple2<Position, EdgePattern>(Position.ZERO, EdgePattern.fromString("????")));
        }
        return Stream.ofAll(placedTiles).flatMap(item -> {
            Position pos = (Position)item._1;
            ArrayList<Tuple2<Position, EdgePattern>> avail = new ArrayList<Tuple2<Position, EdgePattern>>(4);
            for (Position offset : Position.ADJACENT.values()) {
                Position adj = pos.add(offset);
                if (used.contains(adj) || placedTiles.containsKey(adj)) continue;
                avail.add(new Tuple2<Position, EdgePattern>(adj, this.getEdgePattern(adj)));
                used.add(adj);
            }
            return avail;
        });
    }

    default public Stream<Tuple2<Position, EdgePattern>> getHoles() {
        return this.getAvailablePlacements().filter(t -> ((EdgePattern)t._2).wildcardSize() == 0);
    }

    default public EdgePattern getEdgePattern(Position pos) {
        PlacedTile placed = this.getPlacedTile(pos);
        if (placed != null) {
            return placed.getEdgePattern();
        }
        return new EdgePattern(Position.ADJACENT.map((loc, offset) -> {
            Position adj = pos.add((Position)offset);
            PlacedTile adjTile = this.getPlacedTile(adj);
            if (adjTile == null) {
                return new Tuple2<Location, EdgeType>((Location)loc, EdgeType.UNKNOWN);
            }
            EdgeType edge = adjTile.getEdgePattern().at(loc.rev());
            return new Tuple2<Location, EdgeType>((Location)loc, edge);
        }));
    }

    default public Stream<PlacementOption> getTilePlacements(Tile tile) {
        boolean playerHasBridge = this.getPlayers().getPlayerTokenCount(this.getTurnPlayer().getIndex(), BridgeCapability.BrigeToken.BRIDGE) > 0;
        EdgePattern basePattern = tile.getEdgePattern();
        Vector baseBridgePatterns = playerHasBridge ? _This.getBridgePatterns(basePattern) : null;
        return this.getAvailablePlacements().flatMap(avail -> Stream.of(Rotation.values()).map(rot -> {
            Position pos = (Position)avail._1;
            EdgePattern border = (EdgePattern)avail._2;
            EdgePattern tilePattern = basePattern.rotate((Rotation)((Object)((Object)rot)));
            if (border.isMatchingExact(tilePattern)) {
                return new PlacementOption(pos, (Rotation)((Object)((Object)rot)), null);
            }
            if (playerHasBridge) {
                for (Tuple2 t : baseBridgePatterns) {
                    EdgePattern tileWithBridgePattern = ((EdgePattern)t._1).rotate((Rotation)((Object)((Object)rot)));
                    if (!border.isMatchingExact(tileWithBridgePattern)) continue;
                    Location bridgeLocation = ((Location)t._2).rotateCW((Rotation)((Object)((Object)rot)));
                    return new PlacementOption(pos, (Rotation)((Object)((Object)rot)), new FeaturePointer(pos, bridgeLocation));
                }
                for (Location side : Location.SIDES) {
                    EdgePattern borderWithBridgePattern;
                    FeaturePointer bridgePtr;
                    Position adjPos = pos.add(side);
                    if (!this.getPlacedTiles().containsKey(adjPos) || !this.isBridgePlacementAllowed(bridgePtr = side == Location.N || side == Location.S ? new FeaturePointer(adjPos, Location.NS) : new FeaturePointer(adjPos, Location.WE)) || !(borderWithBridgePattern = border.replace(side, EdgeType.ROAD)).isMatchingExact(tilePattern)) continue;
                    return new PlacementOption(pos, (Rotation)((Object)((Object)rot)), bridgePtr);
                }
            }
            return null;
        }).filter(Predicates.isNotNull()).filter(tp -> {
            for (Capability capability : this.getCapabilities().toSeq()) {
                if (capability.isTilePlacementAllowed((GameState)this, tile, (PlacementOption)tp)) continue;
                return false;
            }
            return true;
        }));
    }

    default public boolean isBridgePlacementAllowed(FeaturePointer bridgePtr) {
        Position pos = bridgePtr.getPosition();
        Location loc = bridgePtr.getLocation();
        boolean adjExists = loc.splitToSides().map(l -> this.getPlacedTile(pos.add((Location)l))).find(Predicates.isNotNull()).isDefined();
        if (adjExists) {
            return false;
        }
        Set placedBridges = (Set)this.getCapabilityModel(BridgeCapability.class);
        if (placedBridges.find(fp -> fp.getPosition().equals(pos)).isDefined()) {
            return false;
        }
        PlacedTile placedTile = this.getPlacedTile(pos);
        return placedTile.getEdgePattern().isBridgeAllowed(loc);
    }

    public static class _This {
        private static Vector<Tuple2<EdgePattern, Location>> getBridgePatterns(EdgePattern basePattern) {
            IndexedSeq<Tuple2<EdgePattern, Location>> patterns = Vector.empty();
            for (Location loc : Location.BRIDGES) {
                if (!basePattern.isBridgeAllowed(loc)) continue;
                patterns = patterns.append((Object)new Tuple2<EdgePattern, Location>(basePattern.getBridgePattern(loc), loc));
            }
            return patterns;
        }
    }
}

