/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.FerriesCapabilityModel;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.PlaceFerry;
import com.jcloisterzone.reducers.Reducer;
import com.jcloisterzone.reducers.UndeployMeeple;
import io.vavr.Tuple2;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import java.util.HashSet;

public class ChangeFerry
implements Reducer {
    private final FeaturePointer from;
    private final FeaturePointer to;

    public ChangeFerry(FeaturePointer from, FeaturePointer to) {
        assert (from.getPosition().equals(to.getPosition()));
        this.from = from;
        this.to = to;
    }

    @Override
    public GameState apply(GameState state) {
        state = this.removeFerry(state);
        state = new PlaceFerry(this.to).apply(state);
        LinearSeq disconnectedParts = this.from.getLocation().subtract(this.to.getLocation()).splitToSides().map(loc -> new FeaturePointer(this.from.getPosition(), (Location)loc));
        for (FeaturePointer fp : disconnectedParts) {
            Structure feature = state.getStructure(fp);
            LinearSeq threatened = feature.getMeeples2(state).filter(m -> m._1 instanceof Builder);
            for (Tuple2 t : threatened) {
                if (!feature.getFollowers(state).find(f -> f.getPlayer().equals(((Meeple)t._1).getPlayer())).isEmpty()) continue;
                state = new UndeployMeeple((Meeple)t._1, false).apply(state);
            }
        }
        return state;
    }

    private GameState removeFerry(GameState state) {
        GameState _state;
        Road merged;
        state = state.mapCapabilityModel(FerriesCapability.class, m -> new FerriesCapabilityModel(m.getFerries().remove(this.from), m.getMovedFerries()));
        LinearSeq sides = this.from.getLocation().splitToSides().map(loc -> this.from.setLocation((Location)loc));
        LinearSeq parts = sides.map(arg_0 -> ChangeFerry.lambda$removeFerry$11(merged = (Road)state.getFeature((FeaturePointer)sides.get()), _state = state, arg_0));
        if (((Road)parts.get(0)).getPlaces().size() != merged.getPlaces().size()) {
            for (Road part : parts) {
                state = state.mapFeatureMap(m -> part.getPlaces().toMap(fp -> new Tuple2<FeaturePointer, Road>((FeaturePointer)fp, part)).merge(m));
            }
        }
        return state;
    }

    private static /* synthetic */ Road lambda$removeFerry$11(Road merged, GameState _state, FeaturePointer side) {
        HashSet placesSet = new HashSet();
        merged.findNearest(_state, side, fp -> {
            placesSet.add(fp);
            return false;
        });
        List<FeaturePointer> places = List.ofAll(placesSet);
        LinearSeq initialFeatures = places.map(fp -> {
            PlacedTile pt = _state.getPlacedTile(fp.getPosition());
            return (Road)pt.getInitialFeaturePartOf(fp.getLocation()).placeOnBoard(fp.getPosition(), pt.getRotation());
        });
        boolean isInn = initialFeatures.foldLeft(false, (res, road) -> res != false || road.isInn());
        boolean isLabyrinth = initialFeatures.foldLeft(false, (res, road) -> res != false || road.isLabyrinth());
        Set<FeaturePointer> openTunnelEnds = merged.getOpenTunnelEnds().intersect(places.toSet());
        Set<Edge> openEdges = merged.getOpenEdges().intersect(initialFeatures.flatMap(f -> f.getOpenEdges()).toSet());
        Set<FeaturePointer> neighbouring = merged.getNeighboring().intersect(initialFeatures.flatMap(f -> f.getNeighboring()).toSet());
        return new Road(places, openEdges, neighbouring, isInn, isLabyrinth, openTunnelEnds);
    }
}

