/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.MeepleDeployed;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.DeploymentCheckResult;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.LinkedHashMap;

public class DeployMeeple
implements Reducer {
    private final Meeple meeple;
    private final FeaturePointer fp;

    public DeployMeeple(Meeple meeple, FeaturePointer fp) {
        this.meeple = meeple;
        this.fp = fp;
    }

    @Override
    public GameState apply(GameState state) {
        Structure feature = state.getStructure(this.fp);
        if (feature == null) {
            throw new IllegalArgumentException("There is no feature on " + this.fp);
        }
        DeploymentCheckResult check = this.meeple.isDeploymentAllowed(state, this.fp, feature);
        if (!check.result) {
            throw new IllegalArgumentException(check.error);
        }
        LinkedHashMap<Meeple, FeaturePointer> deployedMeeples = state.getDeployedMeeples();
        state = state.setDeployedMeeples((LinkedHashMap<Meeple, FeaturePointer>)deployedMeeples.put((Object)this.meeple, (Object)this.fp));
        state = state.appendEvent(new MeepleDeployed(PlayEvent.PlayEventMeta.createWithActivePlayer(state), this.meeple, this.fp));
        return state;
    }
}

