/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.AddPoints;
import com.jcloisterzone.reducers.Reducer;
import com.jcloisterzone.reducers.ScoreCastle;
import com.jcloisterzone.reducers.ScoreCompletable;
import com.jcloisterzone.reducers.ScoreFarm;
import com.jcloisterzone.reducers.ScoreFarmBarn;
import com.jcloisterzone.reducers.ScoreFarmWhenBarnIsConnected;
import com.jcloisterzone.reducers.UndeployMeeples;
import io.vavr.Predicates;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Stream;

public class FinalScoring
implements Reducer {
    private <T extends Scoreable> Stream<T> getOccupiedScoreables(GameState state, Class<T> cls) {
        return state.getFeatures(cls).filter(c -> c.isOccupied(state));
    }

    private int getContinuousRowSize(GameState state, Position beginning, Location direction) {
        Position pos = beginning.add(direction);
        int size = 0;
        while (state.getPlacedTiles().containsKey(pos)) {
            ++size;
            pos = pos.add(direction);
        }
        return size;
    }

    private int getMonasteryPoints(GameState state, Position pos) {
        int points = 1;
        for (Location loc : Location.SIDES) {
            points += this.getContinuousRowSize(state, pos, loc);
        }
        return points;
    }

    @Override
    public GameState apply(GameState state) {
        for (Completable completable : this.getOccupiedScoreables(state, Completable.class)) {
            state = new ScoreCompletable(completable, true).apply(state);
        }
        for (Castle castle : this.getOccupiedScoreables(state, Castle.class)) {
            state = new ScoreCastle(castle, 0, true).apply(state);
        }
        LinearSeq monasteries = state.getFeatures().filter(f -> f instanceof Cloister && ((Cloister)f).isMonastery()).map(f -> (Cloister)f);
        for (Cloister cloister : monasteries) {
            int points = this.getMonasteryPoints(state, cloister.getPosition());
            for (Player player : cloister.getMonasteryOwners(state)) {
                Follower follower = cloister.getMonasterySampleFollower(state, player);
                state = new AddPoints(player, points, PointCategory.CLOISTER).apply(state);
                ScoreEvent scoreEvent = new ScoreEvent(points, PointCategory.CLOISTER, true, cloister.getPlace(), follower);
                state = state.appendEvent(scoreEvent);
            }
        }
        for (Farm farm : this.getOccupiedScoreables(state, Farm.class)) {
            boolean hasFollowers;
            boolean hasBarn = farm.getSpecialMeeples(state).find(Predicates.instanceOf(Barn.class)).isDefined();
            boolean bl = hasFollowers = !farm.getFollowers(state).isEmpty();
            if (hasBarn) {
                if (hasFollowers) {
                    state = new ScoreFarmWhenBarnIsConnected(farm).apply(state);
                    state = new UndeployMeeples(farm, false).apply(state);
                }
                state = new ScoreFarmBarn(farm, true).apply(state);
                continue;
            }
            if (!hasFollowers) continue;
            state = new ScoreFarm(farm, true).apply(state);
        }
        for (Capability capability : state.getCapabilities().toSeq()) {
            state = capability.onFinalScoring(state);
        }
        return state;
    }
}

