/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.event.play.NeutralFigureMoved;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.NeutralFiguresState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.LinkedHashMap;

public class MoveNeutralFigure<P extends BoardPointer>
implements Reducer {
    private final Player triggeringPlayer;
    private final NeutralFigure<P> figure;
    private final P pointer;

    public MoveNeutralFigure(NeutralFigure<P> figure, P pointer) {
        this(figure, pointer, null);
    }

    public MoveNeutralFigure(NeutralFigure<P> figure, P pointer, Player triggeringPlayer) {
        this.figure = figure;
        this.pointer = pointer;
        this.triggeringPlayer = triggeringPlayer;
    }

    @Override
    public GameState apply(GameState state) {
        NeutralFiguresState nfState = state.getNeutralFigures();
        BoardPointer from = (BoardPointer)nfState.getDeployedNeutralFigures().get(this.figure).getOrNull();
        nfState = this.pointer == null ? nfState.setDeployedNeutralFigures((LinkedHashMap<NeutralFigure<?>, BoardPointer>)nfState.getDeployedNeutralFigures().remove((Object)this.figure)) : nfState.setDeployedNeutralFigures((LinkedHashMap<NeutralFigure<?>, BoardPointer>)nfState.getDeployedNeutralFigures().put(this.figure, this.pointer));
        state = state.setNeutralFigures(nfState);
        state = state.appendEvent(new NeutralFigureMoved(PlayEvent.PlayEventMeta.createWithPlayer(this.triggeringPlayer), this.figure, from, (BoardPointer)this.pointer));
        return state;
    }
}

