/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.RansomPaidEvent;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.AddPoints;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import java.util.function.Predicate;

public class PayRansom
implements Reducer {
    private final String meepleId;

    public PayRansom(String meepleId) {
        this.meepleId = meepleId;
    }

    @Override
    public GameState apply(GameState state) {
        if (state.hasFlag(Flag.RANSOM_PAID)) {
            throw new IllegalStateException("Ransom can be paid only once a turn.");
        }
        Player player = state.getActivePlayer();
        Predicate<Follower> pred = f -> f.getId().equals(this.meepleId);
        Array model = (Array)state.getCapabilityModel(TowerCapability.class);
        Meeple follower = null;
        Player jailer = null;
        for (int i = 0; i < model.length(); ++i) {
            follower = (Follower)((List)model.get(i)).find(pred).getOrNull();
            if (follower == null) continue;
            jailer = state.getPlayers().getPlayer(i);
            break;
        }
        if (follower == null) {
            throw new IllegalArgumentException(String.format("No such prisoner %s.", this.meepleId));
        }
        if (!follower.getPlayer().equals(player)) {
            new IllegalArgumentException("Cannot pay ransom for opponent's follower.");
        }
        Player _jailer = jailer;
        Meeple _follower = follower;
        state = state.mapCapabilityModel(TowerCapability.class, arg_0 -> PayRansom.lambda$apply$2(_jailer, (Follower)_follower, arg_0));
        state = new AddPoints(player, -3, PointCategory.TOWER_RANSOM).apply(state);
        state = new AddPoints(jailer, 3, PointCategory.TOWER_RANSOM).apply(state);
        state = state.addFlag(Flag.RANSOM_PAID);
        state = state.appendEvent(new RansomPaidEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), (Follower)follower, jailer));
        return state;
    }

    private static /* synthetic */ Array lambda$apply$2(Player _jailer, Follower _follower, Array m) {
        return m.update(_jailer.getIndex(), l -> l.remove(_follower));
    }
}

