/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.LinkedHashMap;

public class PlaceBridge
implements Reducer {
    private final FeaturePointer ptr;
    private boolean silent;

    public PlaceBridge(FeaturePointer ptr, boolean silent) {
        this.ptr = ptr;
        this.silent = silent;
    }

    public PlaceBridge(FeaturePointer ptr) {
        this(ptr, false);
    }

    @Override
    public GameState apply(GameState state) {
        Position bridgePos = this.ptr.getPosition();
        Location bridgeLoc = this.ptr.getLocation();
        LinkedHashMap<Position, PlacedTile> placedTiles = state.getPlacedTiles();
        PlacedTile ptile = placedTiles.get(bridgePos).get();
        Rotation tileRotation = ptile.getRotation();
        ptile = ptile.mapTile(t -> t.addBridge(bridgeLoc.rotateCCW(tileRotation)));
        state = state.setPlacedTiles((LinkedHashMap<Position, PlacedTile>)placedTiles.put((Object)bridgePos, (Object)ptile));
        Bridge bridge = new Bridge(bridgeLoc);
        Road bridgeRoad = bridge.placeOnBoard(bridgePos, Rotation.R0);
        state = state.mapFeatureMap(m -> m.put(this.ptr, bridgeRoad));
        state = state.mapCapabilityModel(BridgeCapability.class, model -> model.add(this.ptr));
        if (!this.silent) {
            state = state.appendEvent(new TokenPlacedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), BridgeCapability.BrigeToken.BRIDGE, this.ptr));
        }
        return state;
    }
}

