/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTunnelToken;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.Tuple2;
import io.vavr.collection.Map;

public class PlaceTunnel
implements Reducer {
    private final TunnelCapability.Tunnel token;
    private final FeaturePointer ptr;

    public PlaceTunnel(TunnelCapability.Tunnel token, FeaturePointer ptr) {
        this.token = token;
        this.ptr = ptr;
    }

    @Override
    public GameState apply(GameState state) {
        Player player = state.getActivePlayer();
        PlacedTunnelToken placedToken = new PlacedTunnelToken(player.getIndex(), this.token);
        Map tunnels = (Map)state.getCapabilityModel(TunnelCapability.class);
        FeaturePointer secondEnd = (FeaturePointer)tunnels.find(t -> t._2 != null && ((PlacedTunnelToken)t._2).equals(placedToken)).map(Tuple2::_1).getOrNull();
        if (secondEnd != null) {
            Road r1 = (Road)state.getFeature(this.ptr);
            Road r2 = (Road)state.getFeature(secondEnd);
            Road merged = r1.connectTunnels(r2, this.ptr, secondEnd);
            Map featureMapUpdate = merged.getPlaces().toMap(fp -> new Tuple2<FeaturePointer, Road>((FeaturePointer)fp, merged));
            state = state.mapFeatureMap(m -> featureMapUpdate.merge(m));
        }
        state = state.addFlag(Flag.TUNNEL_PLACED);
        state = state.setCapabilityModel(TunnelCapability.class, tunnels.put(this.ptr, placedToken));
        state = state.appendEvent(new TokenPlacedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), this.token, this.ptr));
        return state;
    }
}

