/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.event.play.NeutralFigureReturned;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.NeutralFiguresState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.LinkedHashMap;

public class ReturnNeutralFigure
implements Reducer {
    private final Player triggeringPlayer;
    private final NeutralFigure<?> figure;

    public ReturnNeutralFigure(NeutralFigure<?> figure) {
        this(figure, null);
    }

    public ReturnNeutralFigure(NeutralFigure<?> figure, Player triggeringPlayer) {
        this.figure = figure;
        this.triggeringPlayer = triggeringPlayer;
    }

    @Override
    public GameState apply(GameState state) {
        NeutralFiguresState nfState = state.getNeutralFigures();
        BoardPointer from = (BoardPointer)nfState.getDeployedNeutralFigures().get(this.figure).getOrNull();
        nfState = nfState.setDeployedNeutralFigures((LinkedHashMap<NeutralFigure<?>, BoardPointer>)nfState.getDeployedNeutralFigures().remove((Object)this.figure));
        state = state.setNeutralFigures(nfState);
        state = state.appendEvent(new NeutralFigureReturned(PlayEvent.PlayEventMeta.createWithPlayer(this.triggeringPlayer), this.figure, from));
        return state;
    }
}

