/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.MeepleReturned;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Pig;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.Tuple2;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.LinkedHashMap;

public class UndeployMeeple
implements Reducer {
    private final Meeple meeple;
    private final boolean forced;

    public UndeployMeeple(Meeple meeple, boolean forced) {
        this.meeple = meeple;
        this.forced = forced;
    }

    @Override
    public GameState apply(GameState state) {
        FeaturePointer source = this.meeple.getDeployment(state);
        assert (source != null);
        PlayEvent.PlayEventMeta metaWithPlayer = PlayEvent.PlayEventMeta.createWithActivePlayer(state);
        state = this.primaryUndeploy(state, metaWithPlayer, this.meeple, source);
        if (this.meeple instanceof Follower) {
            Player owner = this.meeple.getPlayer();
            PlayEvent.PlayEventMeta metaNoPlayer = PlayEvent.PlayEventMeta.createWithoutPlayer();
            Structure feature = state.getStructure(source);
            LinearSeq threatened = feature.getMeeples2(state).filter(m -> m._1 instanceof Pig || m._1 instanceof Builder).filter(m -> ((Meeple)m._1).getPlayer().equals(owner));
            for (Tuple2 t : threatened) {
                if (!feature.getFollowers(state).find(f -> f.getPlayer().equals(owner)).isEmpty()) continue;
                state = this.undeploy(state, metaNoPlayer, (Meeple)t._1, (FeaturePointer)t._2);
            }
        }
        if (this.meeple instanceof Shepherd) {
            state = state.mapCapabilityModel(SheepCapability.class, tokens -> tokens.remove(source));
        }
        return state;
    }

    protected GameState primaryUndeploy(GameState state, PlayEvent.PlayEventMeta meta, Meeple meeple, FeaturePointer source) {
        return this.undeploy(state, meta, meeple, source);
    }

    private GameState undeploy(GameState state, PlayEvent.PlayEventMeta meta, Meeple meeple, FeaturePointer source) {
        LinkedHashMap<Meeple, FeaturePointer> deployedMeeples = state.getDeployedMeeples();
        state = state.setDeployedMeeples((LinkedHashMap<Meeple, FeaturePointer>)deployedMeeples.remove((Object)meeple));
        state = state.appendEvent(new MeepleReturned(meta, meeple, source, this.forced));
        return state;
    }

    public boolean isForced() {
        return this.forced;
    }
}

