/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.MeepleReturned;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Queue;
import java.util.ArrayList;

public class UndeployMeeples
implements Reducer {
    private final Feature feature;
    private final boolean forced;

    public UndeployMeeples(Feature feature, boolean forced) {
        this.feature = feature;
        this.forced = forced;
    }

    @Override
    public GameState apply(GameState state) {
        HashSet<FeaturePointer> fps = HashSet.ofAll(this.feature.getPlaces());
        ArrayList<Meeple> meeples = new ArrayList<Meeple>();
        ArrayList<MeepleReturned> events = new ArrayList<MeepleReturned>();
        PlayEvent.PlayEventMeta eventMeta = PlayEvent.PlayEventMeta.createWithoutPlayer();
        for (Tuple2 t2 : ((LinkedHashMap)state.getDeployedMeeples().filter(t -> fps.contains((FeaturePointer)t._2))).filter(t -> !(t._1 instanceof Barn))) {
            meeples.add((Meeple)t2._1);
            events.add(new MeepleReturned(eventMeta, (Meeple)t2._1, (FeaturePointer)t2._2, this.forced));
        }
        state = state.setDeployedMeeples((LinkedHashMap<Meeple, FeaturePointer>)state.getDeployedMeeples().removeAll(meeples));
        state = state.setEvents((Queue<PlayEvent>)state.getEvents().appendAll(events));
        return state;
    }

    public boolean isForced() {
        return this.forced;
    }
}

