/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.jcloisterzone.AppUpdate;
import com.jcloisterzone.bugreport.ReportingTool;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.config.ConfigLoader;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.save.SavedGame;
import com.jcloisterzone.game.save.SavedGameParser;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.ClientMessageListener;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.MenuBar;
import com.jcloisterzone.ui.SavegameFileFilter;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.controls.ControlPanel;
import com.jcloisterzone.ui.dialog.AboutDialog;
import com.jcloisterzone.ui.dialog.DiscardedTilesDialog;
import com.jcloisterzone.ui.dialog.HelpDialog;
import com.jcloisterzone.ui.dialog.PreferencesDialog;
import com.jcloisterzone.ui.dialog.TileDistributionWindow;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.MainPanel;
import com.jcloisterzone.ui.gtk.MenuFix;
import com.jcloisterzone.ui.resources.ConvenientResourceManager;
import com.jcloisterzone.ui.resources.PlugableResourceManager;
import com.jcloisterzone.ui.theme.Theme;
import com.jcloisterzone.ui.view.GameView;
import com.jcloisterzone.ui.view.StartView;
import com.jcloisterzone.ui.view.UiView;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.WebSocketConnection;
import com.jcloisterzone.wsio.server.SimpleServer;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.java_websocket.WebSocket;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends JFrame {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String BASE_TITLE = "JCloisterZone";
    private final Path dataDirectory;
    private final Config config;
    private final ConfigLoader configLoader;
    private final ConvenientResourceManager resourceManager;
    private final List<Plugin> plugins;
    private UiView view;
    private Theme theme;
    private DiscardedTilesDialog discardedTilesDialog;
    private HelpDialog helpDialog;
    private AboutDialog aboutDialog;
    private TileDistributionWindow tileDistributionWindow;
    private final AtomicReference<SimpleServer> localServer = new AtomicReference();
    private ClientMessageListener clientMessageListener;
    private HashMap<String, Object> savedGameAnnotations;
    private static Client instance;
    private final Map<String, Clip> resourceSounds = new HashMap<String, Clip>();

    public Client(Path dataDirectory, ConfigLoader configLoader, Config config, List<Plugin> plugins) {
        instance = this;
        this.dataDirectory = dataDirectory;
        this.configLoader = configLoader;
        this.config = config;
        this.plugins = plugins;
        this.resourceManager = new ConvenientResourceManager(new PlugableResourceManager(plugins));
    }

    public static Client getInstance() {
        return instance;
    }

    public boolean mountView(UiView view) {
        if (this.view != null) {
            if (this.view.requestHide(view)) {
                this.view.hide(view);
            } else {
                return false;
            }
        }
        this.cleanContentPane();
        view.show(this.getContentPane());
        this.getContentPane().setVisible(true);
        this.view = view;
        this.logger.info("{} mounted", (Object)view.getClass().getSimpleName());
        this.repaint();
        return true;
    }

    public UiView getView() {
        return this.view;
    }

    private void initWindowSize() {
        String windowSize;
        String string = windowSize = this.config.getDebug() == null ? null : this.config.getDebug().getWindow_size();
        if (System.getProperty("windowSize") != null) {
            windowSize = System.getProperty("windowSize");
        }
        if (windowSize == null || "fullscreen".equals(windowSize)) {
            this.setExtendedState(6);
        } else if ("L".equals(windowSize) || "R".equals(windowSize)) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int dw = gd.getDisplayMode().getWidth();
            int dh = gd.getDisplayMode().getHeight();
            this.setSize(dw / 2, dh - 40);
            this.setLocation("L".equals(windowSize) ? 0 : dw / 2, 0);
        } else {
            String[] sizes = windowSize.split("x");
            if (sizes.length == 2) {
                UiUtils.centerDialog(this, Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1]));
            } else {
                this.logger.warn("Invalid configuration value for windows_size");
                this.setExtendedState(6);
            }
        }
    }

    public void init() {
        this.setLocale(this.config.getLocaleObject());
        this.theme = "dark".equalsIgnoreCase(this.config.getTheme()) ? Theme.DARK : Theme.LIGHT;
        this.config.setDarkTheme(this.theme.isDark());
        this.resetWindowIcon();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            MenuFix.installGtkPopupBugWorkaround();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), e);
        }
        this.theme.setUiMangerDefaults();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Client.this.handleQuit();
            }
        });
        MenuBar menuBar = new MenuBar(this);
        this.setJMenuBar(menuBar);
        this.mountView(new StartView(this));
        this.pack();
        this.initWindowSize();
        this.setTitle(BASE_TITLE);
        this.setVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ev) {
                if (!Client.this.isActive()) {
                    return false;
                }
                if (Client.this.view == null) {
                    return false;
                }
                return Client.this.view.dispatchKeyEvent(ev);
            }
        });
    }

    @Override
    public MenuBar getJMenuBar() {
        return (MenuBar)super.getJMenuBar();
    }

    void resetWindowIcon() {
        this.setIconImage(new ImageIcon(Client.class.getClassLoader().getResource("sysimages/ico.png")).getImage());
    }

    public Theme getTheme() {
        return this.theme;
    }

    public Config getConfig() {
        return this.config;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void saveConfig() {
        this.configLoader.save(this.config);
        this.resourceManager.reload();
    }

    public ConvenientResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public SimpleServer getLocalServer() {
        return this.localServer.get();
    }

    public Connection getConnection() {
        return this.clientMessageListener == null ? null : this.clientMessageListener.getConnection();
    }

    public ClientMessageListener getClientMessageListener() {
        return this.clientMessageListener;
    }

    public void setDiscardedTilesDialog(DiscardedTilesDialog discardedTilesDialog) {
        this.discardedTilesDialog = discardedTilesDialog;
    }

    public void cleanContentPane() {
        Container pane = this.getContentPane();
        pane.setVisible(false);
        pane.removeAll();
    }

    public boolean closeGame() {
        return this.closeGame(false);
    }

    public boolean closeGame(boolean force) {
        SimpleServer server;
        boolean isGameRunning;
        boolean bl = isGameRunning = this.view instanceof GameView && ((GameView)this.view).isGameRunning();
        if (isGameRunning && !"false".equals(System.getProperty("closeGameConfirm"))) {
            int result;
            Object[] options;
            if (this.localServer.get() != null) {
                options = new String[]{I18nUtils._tr("Leave game", new Object[0]), I18nUtils._tr("Cancel", new Object[0])};
                result = JOptionPane.showOptionDialog(this, I18nUtils._tr("The game is not finished. Do you really want to stop game and disconnect all other players?", new Object[0]), I18nUtils._tr("Leave game", new Object[0]), 2, 3, null, options, options[0]);
                if (0 != result) {
                    return false;
                }
            } else {
                options = new String[]{I18nUtils._tr("Leave game", new Object[0]), I18nUtils._tr("Cancel", new Object[0])};
                result = JOptionPane.showOptionDialog(this, I18nUtils._tr("The game is not finished. Do you really want to leave it?", new Object[0]), I18nUtils._tr("Leave game", new Object[0]), 2, 3, null, options, options[0]);
                if (0 != result) {
                    return false;
                }
            }
        }
        this.setTitle(BASE_TITLE);
        this.resetWindowIcon();
        if (this.clientMessageListener != null && !this.clientMessageListener.isPlayOnline()) {
            this.clientMessageListener.getConnection().close();
            this.clientMessageListener = null;
        }
        if ((server = this.localServer.get()) != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
            this.localServer.set(null);
        }
        if (this.view instanceof GameView) {
            ((GameView)this.view).closeGame();
        }
        if (this.discardedTilesDialog != null) {
            this.discardedTilesDialog.dispose();
            this.discardedTilesDialog = null;
        }
        return true;
    }

    private String getUserName() {
        if (System.getProperty("nick") != null) {
            return System.getProperty("nick");
        }
        String name = this.config.getClient_name();
        String string = name = name == null ? "" : name.trim();
        if (name.equals("")) {
            name = System.getProperty("user.name");
        }
        if (name.equals("")) {
            name = UUID.randomUUID().toString().substring(2, 6);
        }
        return name;
    }

    public void connect(String hostname, int port) {
        this.connect(null, hostname, port, false);
    }

    public void connectPlayOnline(String username) {
        String configValue = this.getConfig().getPlay_online_host();
        String[] hp = (configValue == null || configValue.trim().length() == 0 ? "play.jcloisterzone.com" : configValue).split(":");
        int port = 80;
        if (hp.length > 1) {
            port = Integer.parseInt(hp[1]);
        }
        this.connect(username, hp[0], port, true);
    }

    private void connect(String username, String hostname, int port, boolean playOnline) {
        this.clientMessageListener = new ClientMessageListener(this, playOnline);
        try {
            URI uri = new URI("ws", null, "".equals(hostname) ? "localhost" : hostname, port, playOnline ? "/ws" : "/", null, null);
            this.logger.info("Connection to {}", (Object)uri);
            WebSocketConnection conn = this.clientMessageListener.connect(username == null ? this.getUserName() : username, uri);
            conn.setReportingTool(new ReportingTool());
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void createGame() {
        this.createGame(null, null);
    }

    public void createGame(Game game) {
        this.createGame(null, game);
    }

    public void createGame(SavedGame savedGame) {
        this.createGame(savedGame, null);
    }

    private void createGame(SavedGame savedGame, Game game) {
        if (this.closeGame()) {
            this.savedGameAnnotations = savedGame != null ? savedGame.getAnnotations() : null;
            int port = this.config.getPort() == null ? 37447 : this.config.getPort();
            SimpleServer server = new SimpleServer(new InetSocketAddress(port), new SimpleServer.SimpleServerErrorHandler(){

                @Override
                public void onError(WebSocket ws, Exception ex) {
                    if (ex instanceof ClosedByInterruptException) {
                        Client.this.logger.info(ex.toString());
                    } else if (ex instanceof BindException) {
                        Client.this.onServerStartError(ex);
                    } else {
                        Client.this.logger.error(ex.getMessage(), ex);
                    }
                }
            });
            this.localServer.set(server);
            server.createGame(savedGame, game, this.config.getClient_id());
            server.start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.localServer.get() != null) {
                this.connect(null, "localhost", port, false);
            }
        }
    }

    public void onServerStartError(final Exception ex) {
        this.localServer.set(null);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Client this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JOptionPane.showMessageDialog(this.this$0, ex.getLocalizedMessage(), I18nUtils._tr("Error", new Object[0]), 0);
            }
        });
    }

    public File getSavesDirectory() {
        String savesFolderValue = this.getConfig().getSaved_games().getFolder();
        File savesFolder = savesFolderValue == null || savesFolderValue.isEmpty() ? this.dataDirectory.resolve("saves").toFile() : new File(savesFolderValue);
        if (!savesFolder.exists()) {
            savesFolder.mkdir();
        }
        return savesFolder;
    }

    public File getScreenshotDirectory() {
        String screenFolderValue = this.getConfig().getScreenshots().getFolder();
        File folder = screenFolderValue == null || screenFolderValue.isEmpty() ? this.dataDirectory.resolve("screenshots").toFile() : new File(screenFolderValue);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public void handleLoad() {
        File file;
        JFileChooser fc = new JFileChooser(this.getSavesDirectory());
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(I18nUtils._tr("Load game", new Object[0]));
        fc.setDialogType(0);
        fc.setFileFilter(new SavegameFileFilter());
        fc.setLocale(this.getLocale());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
            try {
                SavedGameParser parser = new SavedGameParser();
                JsonReader reader = new JsonReader(new FileReader(file));
                SavedGame sg = parser.fromJson(reader);
                this.createGame(sg);
            }
            catch (JsonSyntaxException | IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), I18nUtils._tr("Error", new Object[0]), 0);
            }
        }
    }

    public void handleQuit() {
        if (this.getView().requestHide(null)) {
            System.exit(0);
        }
    }

    public void showHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = new HelpDialog();
            this.helpDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Client.this.helpDialog = null;
                }
            });
        } else {
            this.helpDialog.toFront();
        }
    }

    public void showAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this, this.config.getOrigin());
            this.aboutDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Client.this.aboutDialog = null;
                }
            });
        } else {
            this.aboutDialog.toFront();
        }
    }

    public void showPreferncesDialog() {
        new PreferencesDialog(this);
    }

    public void showTileDistribution() {
        if (this.tileDistributionWindow == null) {
            this.tileDistributionWindow = new TileDistributionWindow(this);
            this.tileDistributionWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Client.this.tileDistributionWindow = null;
                }
            });
        } else {
            this.tileDistributionWindow.toFront();
        }
    }

    void beep() {
        if (this.config.getBeep_alert().booleanValue()) {
            this.playSound("audio/beep.wav");
        }
    }

    private void playResourceSound(String resourceFilename) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        if (!this.resourceSounds.containsKey(resourceFilename)) {
            BufferedInputStream resourceStream = this.loadResourceAsStream(resourceFilename);
            Clip loadedClip = this.loadSoundFromStream(resourceStream);
            this.resourceSounds.put(resourceFilename, loadedClip);
        }
        Clip clip = this.resourceSounds.get(resourceFilename);
        clip.stop();
        clip.setFramePosition(0);
        clip.start();
    }

    public void playSound(String resourceFilename) {
        try {
            this.playResourceSound(resourceFilename);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private BufferedInputStream loadResourceAsStream(String filename) throws IOException {
        BufferedInputStream resourceStream = new BufferedInputStream(Client.class.getClassLoader().getResource(filename).openStream());
        return resourceStream;
    }

    private Clip loadSoundFromStream(BufferedInputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        AudioFormat format = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(audioInputStream);
        audioInputStream.close();
        return clip;
    }

    public DiscardedTilesDialog getDiscardedTilesDialog() {
        return this.discardedTilesDialog;
    }

    public void showUpdateIsAvailable(AppUpdate appUpdate) {
        if (this.isVisible() && this.view instanceof StartView) {
            ((StartView)this.view).showUpdateIsAvailable(appUpdate);
        } else {
            System.out.println("JCloisterZone " + appUpdate.getVersion() + " is avaiable for download.");
            System.out.println(appUpdate.getDescription());
            System.out.println(appUpdate.getDownloadUrl());
        }
    }

    public void onWebsocketError(Exception ex) {
        this.view.onWebsocketError(ex);
    }

    public void onWebsocketClose(int code, String reason, boolean remote) {
        this.view.onWebsocketClose(code, reason, remote);
    }

    public void onUnhandledWebsocketError(Exception ex) {
        String message;
        if (ex instanceof WebsocketNotConnectedException) {
            message = I18nUtils._tr("Connection lost", new Object[0]);
        } else {
            message = ex.getMessage();
            if (message == null || message.length() == 0) {
                message = ex.getClass().getSimpleName();
            }
            this.logger.error(message, ex);
        }
        JOptionPane.showMessageDialog(this, message, I18nUtils._tr("Error", new Object[0]), 0);
    }

    public HashMap<String, Object> getSavedGameAnnotations() {
        return this.savedGameAnnotations;
    }

    @Deprecated
    public ControlPanel getControlPanel() {
        MainPanel mainPanel = this.getMainPanel();
        if (mainPanel != null) {
            return mainPanel.getControlPanel();
        }
        return null;
    }

    @Deprecated
    public GridPanel getGridPanel() {
        MainPanel mainPanel = this.getMainPanel();
        if (mainPanel != null) {
            return mainPanel.getGridPanel();
        }
        return null;
    }

    @Deprecated
    public MainPanel getMainPanel() {
        if (this.view instanceof GameView) {
            return ((GameView)this.view).getMainPanel();
        }
        return null;
    }
}

