/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.google.common.eventbus.EventBus;
import com.jcloisterzone.EventBusExceptionHandler;
import com.jcloisterzone.EventProxy;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.InvokeInSwingUiAdapter;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.server.RemoteClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProxyUiController<T extends EventProxy> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Client client;
    private final EventBus eventBus;
    private final T eventProxy;
    private InvokeInSwingUiAdapter invokeInSwingUiAdapter;
    private final List<RemoteClient> remoteClients = new ArrayList<RemoteClient>();

    public EventProxyUiController(Client client, T eventProxy) {
        this.client = client;
        this.eventProxy = eventProxy;
        this.eventBus = new EventBus(new EventBusExceptionHandler(this.getClass().getName() + " event bus"));
        this.eventBus.register(this);
        this.invokeInSwingUiAdapter = new InvokeInSwingUiAdapter(this.eventBus);
        eventProxy.getEventBus().register(this.invokeInSwingUiAdapter);
    }

    public void register(Object subscriber) {
        this.logger.debug(String.format("Registering %s to UI event bus", subscriber));
        this.eventBus.register(subscriber);
    }

    public void unregister(Object subscriber) {
        try {
            this.logger.debug(String.format("Unregistering %s to UI event bus", subscriber));
            this.eventBus.unregister(subscriber);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("Subscriber not registered.");
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Config getConfig() {
        return this.client == null ? null : this.client.getConfig();
    }

    public T getEventProxy() {
        return this.eventProxy;
    }

    public List<RemoteClient> getRemoteClients() {
        return this.remoteClients;
    }

    protected InvokeInSwingUiAdapter getInvokeInSwingUiAdapter() {
        return this.invokeInSwingUiAdapter;
    }

    public Connection getConnection() {
        return this.client.getConnection();
    }
}

