/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.jcloisterzone.AppUpdate;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.FileTeeStream;
import com.jcloisterzone.VersionComparator;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.config.ConfigLoader;
import com.jcloisterzone.plugin.NotAPluginException;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.plugin.PluginLoadException;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;
import org.java_websocket.WebSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCloisterZone {
    public static String VERSION = "dev-snapshot";
    public static String BUILD_DATE = "";
    public static final String PROTCOL_VERSION = "4.6.0";
    private Path dataDirectory = this.getDataDirectory();
    protected final transient Logger logger;

    public JCloisterZone() {
        if (!"false".equals(System.getProperty("errorLog"))) {
            FileTeeStream teeStream = new FileTeeStream(System.out, this.dataDirectory.resolve("error.log"));
            System.setOut(teeStream);
            System.setErr(teeStream);
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private Path getDataDirectory(String basePath, String dirName) {
        if (basePath == null || basePath.length() == 0) {
            return null;
        }
        Path path = Paths.get(basePath, new String[0]);
        if (!Files.isWritable(path)) {
            return null;
        }
        File dir = (path = path.resolve(dirName)).toFile();
        if (dir.exists()) {
            return path;
        }
        return dir.mkdir() ? path : null;
    }

    private Path getDataDirectory() {
        Path workingDir;
        Path path;
        String jarPath = ClassLoader.getSystemClassLoader().getResource(".").getPath();
        if (jarPath.matches("/.:/.*")) {
            jarPath = jarPath.substring(1);
        }
        if (Files.isWritable(path = (workingDir = Paths.get(jarPath, new String[0]).normalize().toAbsolutePath()))) {
            return path;
        }
        path = this.getDataDirectory(System.getenv("APPDATA"), "JCloisterZone");
        if (path != null) {
            return path;
        }
        path = this.getDataDirectory(System.getProperty("user.home"), ".jcloisterzone");
        if (path != null) {
            return path;
        }
        System.err.println("Could not locate writeable working dir");
        return workingDir;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    private boolean isPluginEnabled(Config config, Path relPath) {
        String pluginName = relPath.toString();
        for (String path : config.getPlugins().getEnabled_plugins()) {
            if (pluginName.equals(path)) {
                return true;
            }
            if (pluginName.endsWith(".jar") || !(pluginName + ".jar").equals(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginArchive(Path path) {
        String s = path.toString();
        return s.endsWith(".jar") || s.endsWith(".zip");
    }

    public List<Plugin> loadPlugins(Config config) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String folderName : config.getPlugins().getLookup_folders()) {
            try {
                Path pluginFolder = Paths.get(folderName, new String[0]);
                if (!pluginFolder.isAbsolute()) {
                    pluginFolder = Paths.get(this.getClass().getClassLoader().getResource(folderName).toURI());
                }
                DirectoryStream<Path> stream = Files.newDirectoryStream(pluginFolder);
                for (Path fullPath : stream) {
                    boolean isValid;
                    Path relPath = pluginFolder.relativize(fullPath);
                    boolean bl = isValid = !relPath.toString().startsWith(".") && (Files.isDirectory(fullPath, new LinkOption[0]) || this.isPluginArchive(fullPath));
                    if (!isValid) continue;
                    try {
                        Plugin plugin = Plugin.readPlugin(config, relPath, fullPath);
                        if (this.isPluginEnabled(config, relPath)) {
                            plugin.load();
                            plugin.setEnabled(true);
                        }
                        plugins.add(plugin);
                    }
                    catch (NotAPluginException e1) {
                        this.logger.info("{} is not recognized as plugin", (Object)fullPath);
                    }
                    catch (PluginLoadException e2) {
                        this.logger.error(String.format("Unable to load plugin %s", fullPath), e2);
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                this.logger.error("Cannot read plugin directory", e);
            }
        }
        Collections.sort(plugins, new Comparator<Plugin>(){

            private int getPluginPriority(Plugin p) {
                if (p.isDefault()) {
                    return Integer.MAX_VALUE;
                }
                if (p.isExpansionSupported(Expansion.BASIC)) {
                    return 1000 + p.getContainedExpansions().size();
                }
                return 10 + p.getContainedExpansions().size();
            }

            @Override
            public int compare(Plugin o1, Plugin o2) {
                int o1ord = this.getPluginPriority(o1);
                int o2ord = this.getPluginPriority(o2);
                return o1ord - o2ord;
            }
        });
        for (Plugin plugin : plugins) {
            this.logger.info("plugin <{}> loaded, enabled: {}", (Object)plugin.getRelativePath(), (Object)plugin.isEnabled());
        }
        return plugins;
    }

    private void checkForUpdate(Config config, final Client client) {
        final String updateUrlStr = config.getUpdate();
        if (updateUrlStr != null && !VERSION.contains("dev")) {
            new Thread(this){
                final /* synthetic */ JCloisterZone this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        URL url = new URL(updateUrlStr);
                        final AppUpdate update = AppUpdate.fetch(url);
                        if (update != null && new VersionComparator().compare(VERSION, update.getVersion()) < 0) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.client.showUpdateIsAvailable(update);
                                }
                            });
                        }
                    }
                    catch (MalformedURLException e) {
                        this.this$0.logger.error("Malformed key update.url in config file.", e);
                    }
                }
            }.start();
        }
    }

    public void run() {
        System.setProperty("apple.awt.graphics.EnableQ2DX", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JCloisterZone");
        if ("true".equals(System.getProperty("wsdebug"))) {
            WebSocketImpl.DEBUG = true;
        }
        this.logger.info("Data directory {}", (Object)this.dataDirectory.toString());
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    String buildDate;
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    if (!"JCloisterZone".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) continue;
                    String version = manifest.getMainAttributes().getValue("Implementation-Version");
                    if (version != null) {
                        VERSION = version;
                    }
                    if ((buildDate = manifest.getMainAttributes().getValue("Release-Date")) == null) continue;
                    BUILD_DATE = buildDate;
                }
                catch (IOException ex) {
                    this.logger.error(ex.getMessage(), ex);
                }
            }
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex);
        }
        ConfigLoader configLoader = new ConfigLoader(this.dataDirectory);
        Config config = configLoader.load();
        I18nUtils.setLocale(config.getLocaleObject());
        List<Plugin> plugins = this.loadPlugins(config);
        final Client client = new Client(this.dataDirectory, configLoader, config, plugins);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ JCloisterZone this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                client.init();
                Config.DebugConfig debugConfig = client.getConfig().getDebug();
                if (debugConfig != null && debugConfig.isAutostartEnabled()) {
                    if (Boolean.TRUE.equals(debugConfig.getAutostart().getOnline())) {
                        client.connectPlayOnline(null);
                    } else {
                        client.createGame();
                    }
                }
            }
        });
        this.checkForUpdate(config, client);
    }

    public static void main(String[] args) {
        new JCloisterZone().run();
    }
}

