/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.jcloisterzone.config.Config;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.ui.UiUtils;
import java.awt.Color;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerColors {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Color meeple;
    private final Color font;
    private Map<TunnelCapability.Tunnel, Color> tunnelColors;

    public PlayerColors() {
        this.meeple = Color.BLACK;
        this.font = Color.BLACK;
    }

    public PlayerColors(Config.ColorConfig cfg, boolean darkTheme) {
        this.meeple = this.stringToColor(cfg.getMeeple(), Color.BLACK);
        this.font = this.stringToColor(darkTheme ? cfg.getFontDark() : cfg.getFontLight(), this.meeple);
    }

    public Color getMeepleColor() {
        return this.meeple;
    }

    public Color getFontColor() {
        return this.font;
    }

    public Map<TunnelCapability.Tunnel, Color> getTunnelColors() {
        return this.tunnelColors;
    }

    public void setTunnelColors(Map<TunnelCapability.Tunnel, Color> tunnelColors) {
        this.tunnelColors = tunnelColors;
    }

    private Color stringToColor(String s, Color defaultColor) {
        if (s == null || s.equals("")) {
            return defaultColor;
        }
        try {
            return UiUtils.stringToColor(s);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn(e.getMessage());
            return defaultColor;
        }
    }
}

