/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.PlayerClock;
import com.jcloisterzone.action.ConfirmAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.TilePlacementAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.event.ClockUpdateEvent;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.MeepleDeployed;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.BazaarCapabilityModel;
import com.jcloisterzone.game.capability.BazaarItem;
import com.jcloisterzone.game.phase.BazaarPhase;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.FinalScoring;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.annotations.LinkedPanel;
import com.jcloisterzone.ui.controls.ActionPanel;
import com.jcloisterzone.ui.controls.NeutralFigurePanel;
import com.jcloisterzone.ui.controls.PlayerPanel;
import com.jcloisterzone.ui.controls.PlayerPanelImageCache;
import com.jcloisterzone.ui.view.GameView;
import com.jcloisterzone.wsio.message.CommitMessage;
import com.jcloisterzone.wsio.message.PassMessage;
import io.vavr.collection.Array;
import io.vavr.collection.Queue;
import io.vavr.collection.Vector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public class ControlPanel
extends JPanel
implements UIEventListener {
    private static Font FONT_PACK_SIZE = new Font(null, 0, 20);
    @Deprecated
    public static final Color FONT_SHADOW_COLOR = new Color(0, 0, 0, 60);
    public static final int CORNER_DIAMETER = 16;
    public static final int PANEL_WIDTH = 220;
    public static final int PANEL_SHADOW_WIDTH = 3;
    public static final int LEFT_PADDING = 20;
    public static final int LEFT_MARGIN = 15;
    public static final int ACTIVE_MARKER_SIZE = 25;
    public static final int ACTIVE_MARKER_PADDING = 6;
    private static final String PASS_LABEL = I18nUtils._tr("Skip", new Object[0]);
    private static final String CONFIRMATION_LABEL = I18nUtils._tr("Continue", new Object[0]);
    private final Client client;
    private final GameView gameView;
    private final GameController gc;
    private final Game game;
    private JButton passButton;
    private boolean showConfirmRequest;
    private boolean showProjectedPoints;
    private GameState projectedPointsSource = null;
    private ActionPanel actionPanel;
    private PlayerPanel[] playerPanels;
    private NeutralFigurePanel neutralPanel;
    private BazaarSupplyPanel bazaarSupplyPanel;
    private final Timer timer;

    public ControlPanel(GameView gameView) {
        this.client = gameView.getClient();
        this.gameView = gameView;
        this.game = gameView.getGame();
        this.gc = gameView.getGameController();
        this.setOpaque(false);
        this.setLayout(new MigLayout("ins 0, gap 0", "[grow]", ""));
        this.passButton = new JButton(PASS_LABEL);
        this.passButton.setBorder(BorderFactory.createEmptyBorder(1, 30, 1, 30));
        this.passButton.setVisible(false);
        this.passButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.pass();
            }
        });
        this.add((Component)this.passButton, "pos 35 4");
        this.actionPanel = new ActionPanel(gameView);
        this.add((Component)this.actionPanel, "wrap, growx, gapleft 35, h 106");
        if (this.game.getState().getCapabilities().contains(BazaarCapability.class)) {
            this.bazaarSupplyPanel = new BazaarSupplyPanel();
            this.bazaarSupplyPanel.setVisible(false);
            this.add((Component)this.bazaarSupplyPanel, "wrap, growx, gapbottom 12, h 40, hidemode 3");
        }
        Array<Player> players = this.game.getState().getPlayers().getPlayers();
        PlayerPanelImageCache cache = new PlayerPanelImageCache(this.client, this.game);
        this.playerPanels = new PlayerPanel[players.length()];
        for (int i = 0; i < players.length(); ++i) {
            this.playerPanels[i] = new PlayerPanel(this.client, gameView, players.get(i), cache);
            this.add((Component)this.playerPanels[i], "wrap, growx, gapleft 35, gapbottom 12, h pref");
        }
        this.neutralPanel = new NeutralFigurePanel(this.client, this.game, cache);
        this.add((Component)this.neutralPanel, "wrap, growx, gapleft 35, gapbottom 12, h pref");
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PlayerPanel panel : ControlPanel.this.playerPanels) {
                    panel.repaint();
                }
            }
        });
    }

    private void paintBackgroundBody(Graphics2D g2) {
        g2.setColor(this.client.getTheme().getTransparentPanelBg());
        g2.fillRect(35, 0, this.getWidth() - 15 - 20, this.getHeight());
    }

    private void paintBackgroundShadow(Graphics2D g2) {
        int y;
        PlayerPanel pp;
        int h = this.getHeight();
        g2.translate(35, 0);
        GameState state = this.game.getState();
        Player player = state.getTurnPlayer();
        if (player == null) {
            g2.setColor(this.client.getTheme().getTransparentPanelBg());
            g2.fillRect(-20, 0, 20, h);
            g2.setColor(this.client.getTheme().getPanelShadow());
            g2.fillRect(-23, 0, 3, h);
        } else {
            pp = this.playerPanels[player.getIndex()];
            y = pp.getY() + pp.getRealHeight() / 2;
            g2.setColor(this.client.getTheme().getTransparentPanelBg());
            g2.fillRect(-20, 0, 20, y - 25);
            g2.fillRect(-20, y + 25, 20, h - y - 25);
            g2.fillPolygon(new int[]{-20, 0, 0, -6}, new int[]{y - 25, y - 25, y, y}, 4);
            g2.fillPolygon(new int[]{-20, 0, 0, -6}, new int[]{y + 25, y + 25, y, y}, 4);
            g2.setColor(this.client.getTheme().getPanelShadow());
            g2.fillRect(-23, 0, 3, y - 25);
            g2.fillRect(-23, y + 25, 3, h - y + 25);
            g2.fillPolygon(new int[]{-23, -20, -6, -9}, new int[]{y - 25, y - 25, y, y}, 4);
            g2.fillPolygon(new int[]{-23, -20, -6, -9}, new int[]{y + 25, y + 25, y, y}, 4);
        }
        player = state.getActivePlayer();
        if (player != null) {
            pp = this.playerPanels[player.getIndex()];
            y = pp.getY() + pp.getRealHeight() / 2;
            g2.setColor(this.client.getTheme().getMarkerColor());
            g2.fillPolygon(new int[]{-26, -9, -26}, new int[]{y - 25 - 4, y, y + 25 + 4}, 3);
        }
        g2.translate(-35, 0);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform origTransform = g2.getTransform();
        int w = this.getWidth();
        this.paintBackgroundBody(g2);
        TilePack tilePack = this.game.getState().getTilePack();
        g2.setFont(FONT_PACK_SIZE);
        g2.setColor(this.client.getTheme().getHeaderFontColor());
        int packSize = tilePack.totalSize();
        g2.drawString("" + packSize, w - 42, 24);
        boolean doRevalidate = false;
        if (this.bazaarSupplyPanel != null) {
            boolean showSupply;
            BazaarCapabilityModel model = (BazaarCapabilityModel)this.gc.getGame().getState().getCapabilityModel(BazaarCapability.class);
            boolean bl = showSupply = model.getSupply() != null;
            if (showSupply ^ this.bazaarSupplyPanel.isVisible()) {
                doRevalidate = true;
                this.bazaarSupplyPanel.setVisible(showSupply);
            }
        }
        for (PlayerPanel pp : this.playerPanels) {
            doRevalidate = doRevalidate || pp.repaintContent(w);
        }
        boolean bl = doRevalidate = doRevalidate || this.neutralPanel.repaintContent(w);
        if (doRevalidate) {
            this.revalidate();
        }
        g2.setTransform(origTransform);
        super.paint(g2);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintBackgroundShadow((Graphics2D)g);
    }

    private boolean isLastAbbeyPlacement(GameState state) {
        ActionsState as = state.getPlayerActions();
        if (as == null || as.getActions().isEmpty()) {
            return false;
        }
        PlayerAction action = (PlayerAction)as.getActions().get();
        if (!(action instanceof TilePlacementAction)) {
            return false;
        }
        TilePlacementAction tpa = (TilePlacementAction)action;
        if (!AbbeyCapability.isAbbey(tpa.getTile())) {
            return false;
        }
        return state.getTilePack().size() == 0;
    }

    public void pass() {
        GameState state = this.game.getState();
        Player player = state.getActivePlayer();
        if (player == null || !player.isLocalHuman()) {
            return;
        }
        if (this.showConfirmRequest) {
            this.setShowConfirmRequest(false);
            this.gc.getConnection().send(new CommitMessage());
            this.repaint();
        } else {
            ActionsState actions = state.getPlayerActions();
            if (!actions.isPassAllowed()) {
                return;
            }
            if (this.isLastAbbeyPlacement(state)) {
                Object[] options = new String[]{I18nUtils._tr("Skip Abbey", new Object[0]), I18nUtils._tr("Cancel and place Abbey", new Object[0])};
                int result = JOptionPane.showOptionDialog(this.client, I18nUtils._tr("This is your last turn. If you skip it your Abbey remain unplaced.", new Object[0]), I18nUtils._tr("Last chance to place the Abbey", new Object[0]), 2, 3, null, options, options[0]);
                if (result == -1 || result == 1) {
                    return;
                }
            }
            this.gc.getConnection().send(new PassMessage());
        }
    }

    public ActionPanel getActionPanel() {
        return this.actionPanel;
    }

    public void clearActions() {
        this.actionPanel.clearActions();
        this.passButton.setVisible(false);
        this.setShowConfirmRequest(false);
    }

    public boolean isShowPotentialPoints() {
        return this.showProjectedPoints;
    }

    public void setShowProjectedPoints(boolean showProjectedPoints) {
        this.showProjectedPoints = showProjectedPoints;
        if (showProjectedPoints) {
            this.refreshPotentialPoints();
        } else {
            this.gameView.getGridPanel().repaint();
        }
    }

    private void refreshPotentialPoints() {
        if (!this.showProjectedPoints) {
            return;
        }
        GameState state = this.game.getState();
        if (this.projectedPointsSource != state) {
            this.projectedPointsSource = state;
            GameState scored = new FinalScoring().apply(state);
            for (PlayerPanel playerPanel : this.playerPanels) {
                playerPanel.setPotentialPoints(playerPanel.getPlayer().getPoints(scored));
            }
        }
        this.repaint();
    }

    public void setShowConfirmRequest(boolean showConfirmRequest) {
        this.passButton.setText(showConfirmRequest ? CONFIRMATION_LABEL : PASS_LABEL);
        this.passButton.setVisible(showConfirmRequest);
        this.showConfirmRequest = showConfirmRequest;
        this.actionPanel.setShowConfirmRequest(showConfirmRequest, false);
        this.repaint();
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        if (ev.hasPlayerActionsChanged()) {
            GameState state = ev.getCurrentState();
            ActionsState actionsState = state.getPlayerActions();
            this.clearActions();
            if (actionsState != null) {
                boolean isLocal = actionsState.getPlayer().isLocalHuman();
                Vector<PlayerAction<?>> actions = actionsState.getActions();
                PlayerAction first = (PlayerAction)actions.getOrNull();
                if (first instanceof ConfirmAction) {
                    this.handleConfirmAction(state, isLocal);
                } else if (first == null || !first.getClass().isAnnotationPresent(LinkedPanel.class)) {
                    this.actionPanel.onPlayerActionsChanged(actionsState);
                    this.passButton.setVisible(isLocal && actionsState.isPassAllowed());
                }
            }
        }
        this.refreshPotentialPoints();
    }

    public void handleConfirmAction(GameState state, boolean isLocal) {
        if (isLocal) {
            boolean needsConfirm = false;
            PlayEvent last = state.getEvents().last();
            if (last instanceof MeepleDeployed) {
                Config.ConfirmConfig cfg = this.gc.getConfig().getConfirm();
                MeepleDeployed ev = (MeepleDeployed)last;
                if (cfg.getAny_deployment().booleanValue()) {
                    needsConfirm = true;
                } else if (cfg.getFarm_deployment().booleanValue() && ev.getLocation().isFarmLocation()) {
                    needsConfirm = true;
                } else if (cfg.getOn_tower_deployment().booleanValue() && ev.getLocation() == Location.TOWER) {
                    needsConfirm = true;
                }
            }
            if (needsConfirm) {
                this.setShowConfirmRequest(true);
            } else {
                this.gc.getConnection().send(new CommitMessage());
            }
        } else {
            this.actionPanel.setShowConfirmRequest(true, true);
            this.repaint();
        }
    }

    @Subscribe
    public void handleClockUpdateEvent(ClockUpdateEvent ev) {
        this.timer.stop();
        if (ev.isClockRunning() && this.game.getSetup().getRules().get(Rule.CLOCK_PLAYER_TIME).isDefined()) {
            PlayerClock runningClock = ev.getClocks().get(ev.getRunning());
            this.timer.setInitialDelay((int)runningClock.getTime(this.game.getClockStart()) % 1000);
            this.timer.start();
        }
    }

    class BazaarSupplyPanel
    extends JPanel {
        public BazaarSupplyPanel() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g);
            GameState state = ControlPanel.this.game.getState();
            BazaarCapabilityModel model = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class);
            Queue<BazaarItem> supply = model.getSupply();
            if (supply != null && !state.getPhase().equals(BazaarPhase.class)) {
                int x = 35;
                for (BazaarItem bi : supply) {
                    Tile tile = bi.getTile();
                    Image img = ControlPanel.this.client.getResourceManager().getTileImage(tile.getId(), Rotation.R0).getImage();
                    g2.drawImage(img, x, 0, 40, 40, null);
                    x += 45;
                }
            }
        }
    }
}

