/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.NeutralFiguresState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.controls.PlayerPanelImageCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class NeutralFigurePanel
extends JComponent {
    private static final int PADDING_L = 9;
    private static final int PADDING_R = 11;
    private static final int LINE_HEIGHT = 32;
    private int PANEL_WIDTH = 1;
    private BufferedImage bimg;
    private Graphics2D g2;
    private final Client client;
    private final Game game;
    private final PlayerPanelImageCache cache;
    private int realHeight = 1;
    private int bx = 0;
    private int by = 0;

    public NeutralFigurePanel(Client client, Game game, PlayerPanelImageCache cache) {
        this.client = client;
        this.game = game;
        this.cache = cache;
    }

    private Rectangle drawMeepleBox(Graphics2D g2, String imgKey) {
        return this.drawMeepleBox(g2, imgKey, 0, 0);
    }

    private Rectangle drawMeepleBox(Graphics2D g2, String imgKey, int offsetx, int offsety) {
        g2.setColor(Color.WHITE);
        int w = 30;
        int h = 22;
        if (this.bx + w > this.PANEL_WIDTH - 11 - 9) {
            this.bx = 9;
            this.by += 32;
        }
        g2.fillRoundRect(this.bx, this.by, w, h, 8, 8);
        g2.drawImage(this.cache.get(null, imgKey), this.bx + offsetx, this.by - 4 + offsety, null);
        Rectangle rect = null;
        this.bx += w + 8;
        return rect;
    }

    public boolean repaintContent(int width) {
        this.PANEL_WIDTH = width;
        this.bimg = UiUtils.newTransparentImage(this.PANEL_WIDTH, 200);
        this.g2 = this.bimg.createGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.bx = 9;
        this.by = 9;
        GameState state = this.game.getState();
        NeutralFiguresState nfState = state.getNeutralFigures();
        if (nfState.getDragon() != null && nfState.getDragonDeployment() == null) {
            this.drawMeepleBox(this.g2, "dragon", -7, -6);
        }
        if (nfState.getFairy() != null && nfState.getFairyDeployment() == null) {
            this.drawMeepleBox(this.g2, "fairy");
        }
        if (nfState.getMage() != null && nfState.getMageDeployment() == null) {
            this.drawMeepleBox(this.g2, "mage");
        }
        if (nfState.getWitch() != null && nfState.getWitchDeployment() == null) {
            this.drawMeepleBox(this.g2, "witch");
        }
        int oldValue = this.realHeight;
        this.realHeight = this.by + (this.bx > 9 ? 32 : 0);
        if (this.realHeight == 9) {
            this.realHeight = 0;
        }
        this.g2.dispose();
        this.g2 = null;
        return this.realHeight != oldValue;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.PANEL_WIDTH, this.realHeight);
    }

    @Override
    public void paint(Graphics g) {
        if (this.realHeight > 0) {
            Graphics2D parentGraphics = (Graphics2D)g;
            parentGraphics.setColor(this.client.getTheme().getPlayerBoxBg());
            parentGraphics.fillRoundRect(0, 0, this.PANEL_WIDTH + 16, this.realHeight, 16, 16);
            parentGraphics.drawImage(this.bimg, 0, 0, this.PANEL_WIDTH, this.realHeight, 0, 0, this.PANEL_WIDTH, this.realHeight, null);
        }
        super.paintComponent(g);
    }
}

