/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class PlayerPanelImageCache {
    private final ResourceManager rm;
    private Map<String, Image> scaledImages = new HashMap<String, Image>();

    public PlayerPanelImageCache(Client client, Game game) {
        this.rm = client.getResourceManager();
        this.scaleImages(game);
    }

    public Image get(Player player, String key) {
        if (player == null) {
            return this.scaledImages.get(key);
        }
        return this.scaledImages.get(player.getIndex() + key);
    }

    private Image scaleImage(Image img) {
        return new ImageIcon(img.getScaledInstance(30, 30, 4)).getImage();
    }

    private void scaleFigureImages(Player player, Color color, Iterable<? extends Meeple> meeples) {
        for (Meeple meeple : meeples) {
            String key = player.getIndex() + meeple.getClass().getSimpleName();
            if (this.scaledImages.containsKey(key)) continue;
            Image img = this.rm.getLayeredImage(new LayeredImageDescriptor(meeple.getClass(), color));
            this.scaledImages.put(key, this.scaleImage(img));
        }
    }

    private void scaleImages(Game game) {
        GameState state = game.getState();
        for (Player player : state.getPlayers().getPlayers()) {
            Color color = player.getColors().getMeepleColor();
            this.scaleFigureImages(player, color, player.getFollowers(state));
            this.scaleFigureImages(player, color, player.getSpecialMeeples(state));
            Map<TunnelCapability.Tunnel, Color> tunnelColors = player.getColors().getTunnelColors();
            Image tunnelA = this.rm.getLayeredImage(new LayeredImageDescriptor("player-meeples/tunnel", tunnelColors.get(TunnelCapability.Tunnel.TUNNEL_A)));
            Image tunnelB = this.rm.getLayeredImage(new LayeredImageDescriptor("player-meeples/tunnel", tunnelColors.get(TunnelCapability.Tunnel.TUNNEL_B)));
            Image tunnelC = this.rm.getLayeredImage(new LayeredImageDescriptor("player-meeples/tunnel", tunnelColors.get(TunnelCapability.Tunnel.TUNNEL_C)));
            this.scaledImages.put(String.format("%dtunnel.A", player.getIndex()), this.scaleImage(tunnelA));
            this.scaledImages.put(String.format("%dtunnel.B", player.getIndex()), this.scaleImage(tunnelB));
            this.scaledImages.put(String.format("%dtunnel.C", player.getIndex()), this.scaleImage(tunnelC));
        }
        this.scaledImages.put("tower_piece", this.scaleImage(this.rm.getImage("neutral/tower_piece")));
        this.scaledImages.put("king", this.scaleImage(this.rm.getImage("neutral/king")));
        this.scaledImages.put("robber", this.scaleImage(this.rm.getImage("neutral/robber")));
        this.scaledImages.put("bridge", this.scaleImage(this.rm.getImage("neutral/bridge")));
        this.scaledImages.put("castle", this.scaleImage(this.rm.getImage("neutral/castle")));
        this.scaledImages.put("cloth", this.rm.getImage("neutral/cloth"));
        this.scaledImages.put("grain", this.rm.getImage("neutral/grain"));
        this.scaledImages.put("wine", this.rm.getImage("neutral/wine"));
        this.scaledImages.put("abbey", this.scaleImage(this.rm.getTileImage("AM.A", Rotation.R0).getImage()));
        this.scaledImages.put("lb_tower", this.scaleImage(this.rm.getImage("neutral/lb_tower")));
        this.scaledImages.put("lb_house", this.scaleImage(this.rm.getImage("neutral/lb_house")));
        this.scaledImages.put("lb_shed", this.scaleImage(this.rm.getImage("neutral/lb_shed")));
        this.scaledImages.put("gold", this.scaleImage(this.rm.getImage("neutral/gold")));
        Image scaled = new ImageIcon(this.rm.getImage("neutral/dragon").getScaledInstance(42, 42, 4)).getImage();
        this.scaledImages.put("dragon", scaled);
        this.scaledImages.put("fairy", this.scaleImage(this.rm.getImage("neutral/fairy")));
        this.scaledImages.put("mage", this.scaleImage(this.rm.getImage("neutral/mage")));
        this.scaledImages.put("witch", this.scaleImage(this.rm.getImage("neutral/witch")));
    }
}

