/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls.action;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.FairyNextToAction;
import com.jcloisterzone.action.FairyOnTileAction;
import com.jcloisterzone.action.GoldPieceAction;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.PrincessAction;
import com.jcloisterzone.action.TowerPieceAction;
import com.jcloisterzone.action.TunnelAction;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Mayor;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.Pig;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.ui.annotations.LinkedImage;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import java.awt.Color;
import java.awt.Image;

public class ActionWrapper
implements Comparable<ActionWrapper> {
    public static final Color INACTIVE_COLOR = Color.GRAY;
    private final PlayerAction<?> action;

    public ActionWrapper(PlayerAction<?> action) {
        assert (action != null);
        this.action = action;
    }

    public PlayerAction<?> getAction() {
        return this.action;
    }

    public Image getImage(ResourceManager rm, Player player, boolean active) {
        Color color = INACTIVE_COLOR;
        if (active && player != null) {
            color = player.getColors().getMeepleColor();
        }
        return this.getImage(rm, color);
    }

    protected Image getImage(ResourceManager rm, Color color) {
        if (!this.action.getClass().isAnnotationPresent(LinkedImage.class)) {
            throw new UnsupportedOperationException(String.format("Annotate %s with LinkedImage or override getImage()", this.action.getClass().getSimpleName()));
        }
        LinkedImage disp = this.action.getClass().getAnnotation(LinkedImage.class);
        return rm.getLayeredImage(new LayeredImageDescriptor(disp.value(), color));
    }

    public int getOrderingKey() {
        if (this.action instanceof MeepleAction) {
            Class<? extends Meeple> meepleType = ((MeepleAction)this.action).getMeepleType();
            if (meepleType.equals(SmallFollower.class)) {
                return 9;
            }
            if (meepleType.equals(BigFollower.class)) {
                return 10;
            }
            if (meepleType.equals(Barn.class)) {
                return 10;
            }
            if (meepleType.equals(Wagon.class)) {
                return 12;
            }
            if (meepleType.equals(Mayor.class)) {
                return 13;
            }
            if (meepleType.equals(Builder.class)) {
                return 14;
            }
            if (meepleType.equals(Shepherd.class)) {
                return 15;
            }
            if (meepleType.equals(Pig.class)) {
                return 16;
            }
            if (meepleType.equals(Phantom.class)) {
                return 17;
            }
            return 19;
        }
        if (this.action instanceof PrincessAction) {
            return 1;
        }
        if (this.action instanceof TowerPieceAction) {
            return 20;
        }
        if (this.action instanceof GoldPieceAction) {
            return 29;
        }
        if (this.action instanceof FairyNextToAction) {
            return 30;
        }
        if (this.action instanceof FairyOnTileAction) {
            return 30;
        }
        if (this.action instanceof TunnelAction) {
            return ((TunnelAction)this.action).getToken().ordinal() + 40;
        }
        return 50;
    }

    @Override
    public int compareTo(ActionWrapper o) {
        return this.getOrderingKey() - o.getOrderingKey();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getAction().toString() + ')';
    }
}

