/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls.chat;

import com.jcloisterzone.event.ChatEvent;
import com.jcloisterzone.ui.ChannelController;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.wsio.message.PostChatMessage;

public class ChannelChatPanel
extends ChatPanel {
    private final ChannelController cc;

    public ChannelChatPanel(Client client, ChannelController cc) {
        super(client);
        this.cc = cc;
    }

    @Override
    protected ChatPanel.ReceivedChatMessage createReceivedMessage(ChatEvent ev) {
        if (ev.getRemoteClient() == null) {
            return new ChatPanel.ReceivedChatMessage(ev, "* play.jcz *", this.client.getTheme().getChatSystemColor());
        }
        boolean isMe = this.cc.getConnection().getSessionId().equals(ev.getRemoteClient().getSessionId());
        return new ChatPanel.ReceivedChatMessage(ev, ev.getRemoteClient().getName(), isMe ? this.client.getTheme().getChatMyColor() : this.client.getTheme().getChatNeutralColor());
    }

    @Override
    protected PostChatMessage createPostChatMessage(String msg) {
        PostChatMessage pcm = new PostChatMessage(msg);
        pcm.setChannel(this.cc.getChannel().getName());
        return pcm;
    }
}

