/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls.chat;

import com.jcloisterzone.Player;
import com.jcloisterzone.event.ChatEvent;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.wsio.message.PostChatMessage;
import java.awt.Color;

public class GameChatPanel
extends ChatPanel {
    private final Game game;

    public GameChatPanel(Client client, Game game) {
        super(client);
        this.game = game;
    }

    @Override
    protected PostChatMessage createPostChatMessage(String msg) {
        PostChatMessage pcm = new PostChatMessage(msg);
        pcm.setGameId(this.game.getGameId());
        return pcm;
    }

    @Override
    protected ChatPanel.ReceivedChatMessage createReceivedMessage(ChatEvent ev) {
        Color color;
        String nick;
        block6: {
            PlayerSlot[] slots;
            block5: {
                nick = ev.getRemoteClient().getName();
                color = this.client.getTheme().getChatNeutralColor();
                GameState state = this.game.getState();
                if (!this.game.isStarted()) break block5;
                Player selected = null;
                Player active = state.getActivePlayer();
                for (Player player : state.getPlayers().getPlayers()) {
                    boolean isAi;
                    boolean bl = isAi = player.getSlot().getAiClassName() != null;
                    if (!player.getSlot().getSessionId().equals(ev.getRemoteClient().getSessionId())) continue;
                    if (selected == null) {
                        selected = player;
                    } else if (selected.getSlot().getAiClassName() != null && !isAi) {
                        selected = player;
                    }
                    if (!player.equals(active) || isAi) continue;
                    selected = player;
                    break;
                }
                if (selected == null) break block6;
                nick = selected.getNick();
                color = selected.getColors().getFontColor();
                break block6;
            }
            for (PlayerSlot slot : slots = this.game.getPlayerSlots()) {
                if (!ev.getRemoteClient().getSessionId().equals(slot.getSessionId()) || slot.isAi() || slot.getNickname().equals("")) continue;
                nick = slot.getNickname();
                color = slot.getColors().getFontColor();
                break;
            }
        }
        return new ChatPanel.ReceivedChatMessage(ev, nick, color);
    }
}

