/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.dialog;

import com.google.common.base.Joiner;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.component.MultiLineLabel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import io.vavr.Tuple2;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JDialog;
import net.miginfocom.swing.MigLayout;

public class GameSetupDialog
extends JDialog {
    public GameSetupDialog(Client client, Game game) {
        super(client);
        this.setTitle(I18nUtils._tr("Game setup", new Object[0]));
        UiUtils.centerDialog(this, 600, 400);
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setBackground(client.getTheme().getPanelBg());
        pane.setLayout(new MigLayout("", "[]", ""));
        Joiner joiner = Joiner.on(", ").skipNulls();
        pane.add((Component)new ThemedJLabel(I18nUtils._tr("Expansions", new Object[0])), "wrap, w 600, gaptop 5");
        MultiLineLabel lExpansion = new MultiLineLabel(joiner.join(game.getSetup().getExpansions()));
        pane.add((Component)lExpansion, "wrap, w 600");
        joiner = Joiner.on("\n").skipNulls();
        pane.add((Component)new ThemedJLabel(I18nUtils._tr("Rules", new Object[0])), "wrap, w 600, gaptop 10");
        ArrayList<String> rules = new ArrayList<String>();
        for (Tuple2 tuple2 : game.getSetup().getRules()) {
            Rule rule = (Rule)((Object)tuple2._1);
            if (rule.getType().equals(Boolean.class)) {
                if (rule == Rule.RANDOM_SEATING_ORDER || tuple2._2.equals(Boolean.FALSE)) continue;
                rules.add(rule.getLabel());
                continue;
            }
            rules.add(rule.getLabel() + " = " + tuple2._2);
        }
        MultiLineLabel lRules = new MultiLineLabel(joiner.join(rules));
        pane.add((Component)lRules, "wrap, w 600");
    }
}

