/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.dialog;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.TilePackBuilder;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.WrapLayout;
import com.jcloisterzone.ui.gtk.ThemedJList;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.resources.TileImage;
import com.jcloisterzone.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TileDistributionWindow
extends JFrame {
    final Client client;
    final JScrollPane scrollPane;
    final JPanel content = new ThemedJPanel();
    final TilePackBuilder tilePackBuilder;
    private static Font FONT = new Font("Dialog", 0, 26);
    public static final int SIZE = 160;
    public static final int BANNER = 34;

    public TileDistributionWindow(Client client) {
        super(I18nUtils._tr("Tile Distribution", new Object[0]));
        this.client = client;
        this.tilePackBuilder = new TilePackBuilder();
        this.tilePackBuilder.setConfig(client.getConfig());
        this.setDefaultCloseOperation(2);
        UiUtils.centerDialog(this, Math.min(client.getWidth(), 890), client.getHeight() - 40);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().setBackground(client.getTheme().getPanelBg());
        final ThemedJList<Expansion> list = new ThemedJList<Expansion>((T[])this.getImplementedExpansions());
        list.setSelectionMode(0);
        list.setPreferredSize(new Dimension(200, client.getHeight()));
        list.setSelectedValue(Expansion.BASIC, true);
        list.setBorder(new EmptyBorder(4, 4, 4, 4));
        list.addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ TileDistributionWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.this$0.fillContent((Expansion)list.getSelectedValue());
            }
        });
        this.getContentPane().add(list, "West");
        this.content.setLayout(new WrapLayout(0, 3, 3));
        this.scrollPane = new JScrollPane(this.content, 20, 31);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.fillContent(Expansion.BASIC);
        this.setVisible(true);
    }

    private Expansion[] getImplementedExpansions() {
        ArrayList<Expansion> exps = new ArrayList<Expansion>();
        for (Expansion exp : Expansion.values()) {
            if (exp == Expansion.PHANTOM || exp == Expansion.LITTLE_BUILDINGS) continue;
            exps.add(exp);
        }
        return exps.toArray(new Expansion[exps.size()]);
    }

    private void fillContent(Expansion exp) {
        this.content.removeAll();
        Dimension dim = new Dimension(160, 194);
        for (TilePackBuilder.TileCount tc : this.tilePackBuilder.getExpansionTiles(exp)) {
            TileLabel tileLabel = new TileLabel(this.client.getTheme(), exp, tc);
            tileLabel.setPreferredSize(dim);
            this.content.add(tileLabel);
        }
        this.content.revalidate();
        this.scrollPane.repaint();
    }

    private class TileLabel
    extends JPanel {
        private final TileImage image;
        private final Theme theme;
        private String count;

        public TileLabel(Theme theme, Expansion exp, TilePackBuilder.TileCount tc) {
            this.theme = theme;
            this.image = TileDistributionWindow.this.client.getResourceManager().getTileImage(tc.tileId, Rotation.R0);
            this.count = tc.count == null ? "" : tc.count + "";
        }

        @Override
        public void paintComponent(Graphics g) {
            Color bgColor;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.image != null) {
                g2.drawImage(this.image.getImage(), 0, 0, 160, 160, this);
            }
            g2.setColor((bgColor = this.theme.getTileDistCountBg()) == null ? Color.WHITE : bgColor);
            g2.fillRect(0, 160, 160, 34);
            Color textColor = this.theme.getTextColor();
            g2.setColor(textColor == null ? Color.BLACK : textColor);
            g2.setFont(FONT);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.drawString(this.count, 80, 186);
        }
    }
}

