/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.Player;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.EventProxyUiController;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.annotations.LinkedPanel;
import com.jcloisterzone.ui.controls.ControlPanel;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.grid.DragInsensitiveMouseClickListener;
import com.jcloisterzone.ui.grid.ForwardBackwardListener;
import com.jcloisterzone.ui.grid.GameEventsPanel;
import com.jcloisterzone.ui.grid.GridLayer;
import com.jcloisterzone.ui.grid.actionpanel.ActionInteractionPanel;
import com.jcloisterzone.ui.grid.layer.AbstractAreaLayer;
import com.jcloisterzone.ui.grid.layer.EventsOverlayLayer;
import com.jcloisterzone.ui.grid.layer.TileActionLayer;
import com.jcloisterzone.ui.view.GameView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridPanel
extends JPanel
implements ForwardBackwardListener,
UIEventListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = -7013723613801929324L;
    public static int INITIAL_TILE_WIDTH = 120;
    private static final Color MESSAGE_ERROR = new Color(186, 61, 61, 245);
    private static final Color MESSAGE_INFO = new Color(79, 146, 255, 245);
    private static final Color MESSAGE_HINT = new Color(147, 146, 155, 245);
    final Client client;
    final GameView gameView;
    final GameController gc;
    private final ControlPanel controlPanel;
    private final ChatPanel chatPanel;
    private ActionInteractionPanel<?> actionInteractionPanel;
    private final GameEventsPanel eventsPanel;
    private boolean isEventsPanelVisible = true;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int tileWidth;
    private int tileHeight;
    private Rotation boardRotation = Rotation.R0;
    private double meepleScaleFactor = 1.0;
    private int offsetX;
    private int offsetY;
    private double cx = 0.0;
    private double cy = 0.0;
    private MoveCenterAnimation moveAnimation;
    private List<GridLayer> layers = new ArrayList<GridLayer>();
    private ErrorMessagePanel errorMsg;
    private String errorCode;
    public static final ImageIcon CLOSE_ICON = UiUtils.scaleImageIcon("sysimages/close-white.png", 20, 20);

    public GridPanel(Client client, GameView gameView, ControlPanel controlPanel, ChatPanel chatPanel) {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(new MigLayout());
        this.client = client;
        this.gameView = gameView;
        this.gc = gameView.getGameController();
        this.controlPanel = controlPanel;
        boolean networkGame = "true".equals(System.getProperty("forceChat"));
        for (Player p : this.gc.getGame().getState().getPlayers().getPlayers()) {
            if (p.getSlot().isOwn()) continue;
            networkGame = true;
            break;
        }
        this.chatPanel = networkGame ? chatPanel : null;
        Plugin rp = this.getBaseExpansionPlugin();
        if (rp != null) {
            this.meepleScaleFactor = Math.sqrt(rp.getImageSizeRatio());
        }
        this.updateTileSize((int)((double)INITIAL_TILE_WIDTH / rp.getImageSizeRatio()));
        this.registerMouseListeners();
        this.add((Component)controlPanel, "pos (100%-255) 0 100% 100%");
        if (chatPanel != null) {
            chatPanel.initHidingMode();
            this.add((Component)chatPanel, "pos 0 0 250 100%");
        }
        this.eventsPanel = new GameEventsPanel(this.gc);
        this.add((Component)this.eventsPanel, "pos 0 0 (100%-242) 36");
        this.setComponentZOrder(this.eventsPanel, chatPanel == null ? 1 : 2);
    }

    @Override
    public void registerTo(EventProxyUiController<?> gc) {
        UIEventListener.super.registerTo(gc);
        for (GridLayer layer : this.layers) {
            if (!(layer instanceof UIEventListener)) continue;
            ((UIEventListener)((Object)layer)).registerTo(gc);
        }
    }

    @Override
    public void unregisterFrom(EventProxyUiController<?> gc) {
        UIEventListener.super.unregisterFrom(gc);
        for (GridLayer layer : this.layers) {
            if (!(layer instanceof UIEventListener)) continue;
            ((UIEventListener)((Object)layer)).unregisterFrom(gc);
        }
    }

    public double getMeepleScaleFactor() {
        return this.meepleScaleFactor;
    }

    private Plugin getBaseExpansionPlugin() {
        for (Plugin plugin : this.client.getPlugins()) {
            if (!plugin.isEnabled() || !plugin.isExpansionSupported(Expansion.BASIC)) continue;
            return plugin;
        }
        return null;
    }

    private void updateTileSize(int baseWidth) {
        Plugin plugin = this.getBaseExpansionPlugin();
        double ratio = plugin == null ? 1.0 : plugin.getImageSizeRatio();
        this.tileWidth = baseWidth;
        this.tileHeight = (int)(ratio * (double)baseWidth);
    }

    public void toggleGameEvents(boolean visible) {
        this.isEventsPanelVisible = visible;
        this.eventsPanel.setVisible(visible);
        if (visible) {
            this.showLayer(EventsOverlayLayer.class);
        } else {
            this.hideLayer(EventsOverlayLayer.class);
        }
    }

    @Override
    public void forward() {
        if (this.actionInteractionPanel instanceof ForwardBackwardListener) {
            ((ForwardBackwardListener)((Object)this.actionInteractionPanel)).forward();
        }
        this.controlPanel.getActionPanel().forward();
    }

    @Override
    public void backward() {
        if (this.actionInteractionPanel instanceof ForwardBackwardListener) {
            ((ForwardBackwardListener)((Object)this.actionInteractionPanel)).backward();
        }
        this.controlPanel.getActionPanel().backward();
    }

    public void removeInteractionPanels() {
        int l = this.getComponents().length;
        for (int i = l - 1; i > 0; --i) {
            Component child = this.getComponent(i);
            if (child != this.actionInteractionPanel) continue;
            this.remove(i);
            break;
        }
        this.actionInteractionPanel = null;
    }

    private void registerMouseListeners() {
        DragInsensitiveMouseClickListener listener = new DragInsensitiveMouseClickListener(new GridPanelMouseListener());
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GridPanel.this.zoom((double)(-e.getWheelRotation()) * 0.5);
            }
        });
    }

    public Client getClient() {
        return this.client;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    public GameEventsPanel getEventsPanel() {
        return this.eventsPanel;
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        LinkedPanel panelAnnotation;
        GameState state = ev.getCurrentState();
        PlayerAction<?> first = state.getAction();
        LinkedPanel linkedPanel = panelAnnotation = first == null ? null : first.getClass().getAnnotation(LinkedPanel.class);
        if (panelAnnotation == null) {
            this.removeInteractionPanels();
        } else {
            Class<ActionInteractionPanel<?>> cls = panelAnnotation.value();
            if (!cls.isInstance(this.actionInteractionPanel)) {
                if (this.actionInteractionPanel != null) {
                    this.removeInteractionPanels();
                }
                try {
                    this.actionInteractionPanel = cls.getConstructor(Client.class, GameController.class).newInstance(this.client, this.gc);
                    int width = Math.max(250, (int)this.actionInteractionPanel.getPreferredSize().getWidth());
                    int left = 275 + width;
                    int top = this.isEventsPanelVisible ? 36 : 0;
                    String constraints = String.format("pos (100%%-%d) %d (100%%-275) 100%%", left, top);
                    this.add(this.actionInteractionPanel, constraints);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            this.actionInteractionPanel.setGameState(state);
            this.revalidate();
        }
        if (ev.hasPlacedTilesChanged()) {
            Rectangle rect = state.getBoardBounds();
            this.left = rect.x;
            this.right = rect.x + rect.width;
            this.top = rect.y;
            this.bottom = rect.y + rect.height;
        }
        this.eventsPanel.handleGameChanged(ev);
        this.repaint();
    }

    public void moveCenter(int xSteps, int ySteps) {
        double dx = (float)xSteps * 30.0f / (float)this.tileWidth;
        double dy = (float)ySteps * 30.0f / (float)this.tileHeight;
        this.moveCenterTo(this.cx + dx, this.cy + dy);
    }

    public void moveCenterToAnimated(double cx, double cy) {
        if (this.moveAnimation != null) {
            this.moveAnimation.setCancel(true);
        }
        this.moveAnimation = new MoveCenterAnimation(cx, cy);
        this.moveAnimation.start();
    }

    private void moveCenterTo(double cx, double cy) {
        if (cx < (double)((float)this.left - 0.5f)) {
            cx = (float)this.left - 0.5f;
        }
        if (cx > (double)((float)this.right + 0.5f)) {
            cx = (float)this.right + 0.5f;
        }
        if (cy < (double)((float)this.top - 0.5f)) {
            cy = (float)this.top - 0.5f;
        }
        if (cy > (double)((float)this.bottom + 0.5f)) {
            cy = (float)this.bottom + 0.5f;
        }
        this.cx = cx;
        this.cy = cy;
        this.repaint();
    }

    public void zoom(double steps) {
        int size = (int)((double)this.tileWidth * Math.pow(1.3, steps));
        if (size < 25) {
            size = 25;
        }
        if (size > 300) {
            size = 300;
        }
        this.setZoomSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setZoomSize(int size) {
        if (size == this.tileWidth) {
            return;
        }
        this.updateTileSize(size);
        List<GridLayer> list = this.layers;
        synchronized (list) {
            for (GridLayer layer : this.layers) {
                layer.zoomChanged(this.tileWidth);
            }
        }
        this.moveCenterTo(this.cx, this.cy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateBoard() {
        this.boardRotation = this.boardRotation.next();
        List<GridLayer> list = this.layers;
        synchronized (list) {
            for (GridLayer layer : this.layers) {
                layer.boardRotated(this.boardRotation);
            }
        }
        this.repaint();
    }

    public Rotation getBoardRotation() {
        return this.boardRotation;
    }

    void addLayer(GridLayer layer) {
        this.addLayer(layer, true);
    }

    void addLayer(GridLayer layer, boolean visible) {
        this.layers.add(layer);
        if (visible) {
            layer.onShow();
        }
    }

    public void showLayer(GridLayer layer) {
        if (!layer.isVisible()) {
            layer.onShow();
            this.repaint();
        }
    }

    public void showLayer(Class<? extends GridLayer> layerType) {
        for (GridLayer layer : this.layers) {
            if (!layerType.isInstance(layer) || layer.isVisible()) continue;
            layer.onShow();
        }
        this.repaint();
    }

    public void hideLayer(GridLayer layer) {
        if (layer.isVisible()) {
            layer.onHide();
            this.repaint();
        }
    }

    public void hideLayer(Class<? extends GridLayer> layerType) {
        for (GridLayer layer : this.layers) {
            if (!layerType.isInstance(layer) || !layer.isVisible()) continue;
            layer.onHide();
        }
        this.repaint();
    }

    public <T extends GridLayer> T findLayer(Class<T> type) {
        for (GridLayer layer : this.layers) {
            if (!type.isInstance(layer)) continue;
            return (T)layer;
        }
        throw new NoSuchElementException("Layer " + type.toString() + " doesn't exist.");
    }

    public boolean isLayerVisible(Class<? extends GridLayer> type) {
        for (GridLayer layer : this.layers) {
            if (!layer.isVisible() || !type.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    public void clearActionDecorations() {
        this.hideLayer(AbstractAreaLayer.class);
        this.hideLayer(TileActionLayer.class);
    }

    public void showInfoMessage(String errorMessage, String errCode) {
        this.showMessage(MESSAGE_INFO, errorMessage, errCode);
    }

    public void showErrorMessage(String errorMessage, String errCode) {
        this.showMessage(MESSAGE_ERROR, errorMessage, errCode);
    }

    private void showMessage(Color color, String errorMessage, String errCode) {
        if (this.errorMsg != null) {
            this.remove(this.errorMsg);
        }
        this.errorCode = errCode;
        this.errorMsg = new ErrorMessagePanel(color, errorMessage);
        this.errorMsg.setOpaque(true);
        this.add((Component)this.errorMsg, "pos 0 0 (100%-242) 30");
        this.setComponentZOrder(this.errorMsg, 1);
        this.revalidate();
        this.repaint();
    }

    public void hideErrorMessage(String errorCode) {
        if (errorCode != null && !errorCode.equals(this.errorCode)) {
            return;
        }
        if (this.errorMsg != null) {
            this.remove(this.errorMsg);
            this.errorMsg = null;
            this.errorCode = null;
            this.repaint();
        }
    }

    private int calculateCenterX() {
        return (this.getWidth() - 220 - this.tileWidth) / 2;
    }

    private int calculateCenterY() {
        return (this.getHeight() - this.tileHeight) / 2;
    }

    public Point2D getRelativePoint(Point2D point) {
        AffineTransform af = this.boardRotation.inverse().getAffineTransform(this.tileWidth, this.tileHeight);
        af.translate(-this.offsetX, -this.offsetY);
        return af.transform(point, null);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform origTransform = g2.getTransform();
        this.offsetX = this.calculateCenterX() - (int)(this.cx * (double)this.tileWidth);
        this.offsetY = this.calculateCenterY() - (int)(this.cy * (double)this.tileHeight);
        g2.translate(this.offsetX, this.offsetY);
        if (this.boardRotation != Rotation.R0) {
            AffineTransform af = this.boardRotation.getAffineTransform(this.tileWidth, this.tileHeight);
            g2.transform(af);
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (GridLayer layer : this.layers) {
            if (!layer.isVisible()) continue;
            layer.paint(g2);
        }
        g2.setTransform(origTransform);
        super.paintChildren(g);
    }

    public BufferedImage takeScreenshot() {
        Integer screenshotScaleValue = this.client.getConfig().getScreenshots().getScale();
        int screenshotScale = screenshotScaleValue == null ? 120 : screenshotScaleValue;
        int totalWidth = screenshotScale * (this.right - this.left + 1);
        int totalHeight = screenshotScale * (this.bottom - this.top + 1);
        int transX = -screenshotScale * this.left;
        int transY = -screenshotScale * this.top;
        BufferedImage im = new BufferedImage(totalWidth + this.controlPanel.getWidth(), totalHeight, 2);
        Graphics2D graphics = (Graphics2D)im.getGraphics();
        if (!"true".equals(System.getProperty("transparentScreenshots"))) {
            graphics.setBackground(new Color(240, 240, 240, 255));
            graphics.clearRect(0, 0, im.getWidth(), im.getHeight());
        }
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(transX, transY);
        int origWidth = this.tileWidth;
        this.updateTileSize(screenshotScale);
        for (GridLayer layer : this.layers) {
            if (!layer.isVisible()) continue;
            layer.zoomChanged(screenshotScale);
            layer.paint(graphics);
            layer.zoomChanged(origWidth);
        }
        this.updateTileSize(origWidth);
        graphics.translate(-transX, -transY);
        graphics.translate(totalWidth + 30, 0);
        this.controlPanel.paint(graphics);
        return im;
    }

    class GridPanelMouseListener
    extends MouseAdapter
    implements MouseInputListener {
        private MouseEvent dragSource;
        double sourceCx;
        double sourceCy;

        GridPanelMouseListener() {
        }

        private void moveTo(MouseEvent e) {
            int clickX = e.getX() - GridPanel.this.offsetX;
            int clickY = e.getY() - GridPanel.this.offsetY;
            GridPanel.this.moveCenterToAnimated((double)clickX / (double)GridPanel.this.tileWidth, (double)clickY / (double)GridPanel.this.tileHeight);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            switch (e.getButton()) {
                case 2: {
                    this.moveTo(e);
                    break;
                }
                case 3: {
                    if (e.isShiftDown()) {
                        this.moveTo(e);
                        break;
                    }
                }
                case 5: {
                    GridPanel.this.forward();
                    break;
                }
                case 4: {
                    GridPanel.this.backward();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragSource = e;
            this.sourceCx = GridPanel.this.cx;
            this.sourceCy = GridPanel.this.cy;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragSource = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.dragSource == null) {
                return;
            }
            int dx = e.getX() - this.dragSource.getX();
            int dy = e.getY() - this.dragSource.getY();
            double rdx = (double)dx / (double)GridPanel.this.tileWidth;
            double rdy = (double)dy / (double)GridPanel.this.tileHeight;
            GridPanel.this.moveCenterTo(this.sourceCx - rdx, this.sourceCy - rdy);
        }
    }

    class MoveCenterAnimation
    extends Thread {
        private double toCx;
        private double toCy;
        private double fromCx;
        private double fromCy;
        long start;
        long end;
        private boolean cancel;

        public MoveCenterAnimation(double toCx, double toCy) {
            this.moveTo(toCx, toCy);
        }

        private void moveTo(double toCx, double toCy) {
            this.toCx = toCx;
            this.toCy = toCy;
            this.fromCx = GridPanel.this.cx;
            this.fromCy = GridPanel.this.cy;
            this.start = System.currentTimeMillis();
            this.end = this.start + 100L;
        }

        public void setCancel(boolean cancel) {
            this.cancel = cancel;
        }

        @Override
        public void run() {
            long t;
            while (!this.cancel && (t = System.currentTimeMillis()) < this.end) {
                double dx = (double)(t - this.start) / (double)(this.end - this.start) * (this.toCx - this.fromCx);
                double dy = (double)(t - this.start) / (double)(this.end - this.start) * (this.toCy - this.fromCy);
                GridPanel.this.moveCenterTo(this.fromCx + dx, this.fromCy + dy);
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.cancel) {
                GridPanel.this.moveCenterTo(this.toCx, this.toCy);
            }
        }
    }

    class ErrorMessagePanel
    extends JPanel {
        public ErrorMessagePanel(Color color, String text) {
            this.setBackground(color);
            this.setLayout(new MigLayout("fill", "[]push[]"));
            JLabel label = new JLabel(text);
            label.setForeground(Color.WHITE);
            label.setFont(new Font(null, 0, 16));
            JLabel icon = new JLabel(CLOSE_ICON);
            icon.setCursor(Cursor.getPredefinedCursor(12));
            icon.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ErrorMessagePanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.this$1.GridPanel.this.hideErrorMessage(null);
                }
            });
            this.add(label);
            this.add(icon);
        }
    }
}

