/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid;

import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.state.CapabilitiesState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.controls.ControlPanel;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AnimationLayer;
import com.jcloisterzone.ui.grid.layer.BridgeLayer;
import com.jcloisterzone.ui.grid.layer.CastleLayer;
import com.jcloisterzone.ui.grid.layer.EventsOverlayLayer;
import com.jcloisterzone.ui.grid.layer.FarmHintsLayer;
import com.jcloisterzone.ui.grid.layer.FeatureAreaLayer;
import com.jcloisterzone.ui.grid.layer.FerriesLayer;
import com.jcloisterzone.ui.grid.layer.FollowerAreaLayer;
import com.jcloisterzone.ui.grid.layer.GoldLayer;
import com.jcloisterzone.ui.grid.layer.LittleBuildingActionLayer;
import com.jcloisterzone.ui.grid.layer.MeepleLayer;
import com.jcloisterzone.ui.grid.layer.PlacementHistory;
import com.jcloisterzone.ui.grid.layer.SheepLayer;
import com.jcloisterzone.ui.grid.layer.TileActionLayer;
import com.jcloisterzone.ui.grid.layer.TileLayer;
import com.jcloisterzone.ui.grid.layer.TilePlacementLayer;
import com.jcloisterzone.ui.grid.layer.TokenLayer;
import com.jcloisterzone.ui.grid.layer.TowerLayer;
import com.jcloisterzone.ui.view.GameView;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public class MainPanel
extends JPanel
implements UIEventListener {
    private final Client client;
    private final GameView gameView;
    private final GameController gc;
    private final Game game;
    private GridPanel gridPanel;
    private ControlPanel controlPanel;
    private ChatPanel chatPanel;
    private FarmHintsLayer farmHintLayer;
    private EventsOverlayLayer eventsOverlayPanel;
    private PlacementHistory placementHistoryLayer;

    public MainPanel(Client client, GameView gameView, ChatPanel chatPanel) {
        this.client = client;
        this.gameView = gameView;
        this.gc = gameView.getGameController();
        this.game = this.gc.getGame();
        this.chatPanel = chatPanel;
        this.setLayout(new BorderLayout());
        this.controlPanel = new ControlPanel(gameView);
        this.gridPanel = new GridPanel(client, gameView, this.controlPanel, chatPanel);
        MeepleLayer meepleLayer = new MeepleLayer(this.gridPanel, this.gc);
        TilePlacementLayer tilePlacementLayer = new TilePlacementLayer(this.gridPanel, this.gc);
        TileLayer tileLayer = new TileLayer(this.gridPanel, this.gc);
        tileLayer.setTilePlacmentLayer(tilePlacementLayer);
        this.farmHintLayer = new FarmHintsLayer(this.gridPanel, this.gc);
        CapabilitiesState capabs = this.game.getState().getCapabilities();
        this.gridPanel.addLayer(tilePlacementLayer, false);
        this.gridPanel.addLayer(tileLayer);
        this.gridPanel.addLayer(this.farmHintLayer, false);
        if (capabs.contains(CastleCapability.class)) {
            this.gridPanel.addLayer(new CastleLayer(this.gridPanel, this.gc));
        }
        if (capabs.contains(TowerCapability.class)) {
            this.gridPanel.addLayer(new TowerLayer(this.gridPanel, this.gc));
        }
        if (capabs.contains(FerriesCapability.class)) {
            this.gridPanel.addLayer(new FerriesLayer(this.gridPanel, this.gc));
        }
        this.gridPanel.addLayer(new TokenLayer(this.gridPanel, this.gc));
        if (capabs.contains(SheepCapability.class)) {
            this.gridPanel.addLayer(new SheepLayer(this.gridPanel, this.gc));
        }
        this.gridPanel.addLayer(meepleLayer);
        if (capabs.contains(BridgeCapability.class)) {
            BridgeLayer bridgeLayer = new BridgeLayer(this.gridPanel, this.gc);
            bridgeLayer.setMeepleLayer(meepleLayer);
            this.gridPanel.addLayer(bridgeLayer);
        }
        if (capabs.contains(GoldminesCapability.class)) {
            this.gridPanel.addLayer(new GoldLayer(this.gridPanel, this.gc));
        }
        this.gridPanel.addLayer(new FollowerAreaLayer(this.gridPanel, this.gc, meepleLayer), false);
        this.gridPanel.addLayer(new FeatureAreaLayer(this.gridPanel, this.gc), false);
        this.gridPanel.addLayer(new TileActionLayer(this.gridPanel, this.gc), false);
        if (capabs.contains(LittleBuildingsCapability.class)) {
            this.gridPanel.addLayer(new LittleBuildingActionLayer(this.gridPanel, this.gc), false);
        }
        this.gridPanel.addLayer(new AnimationLayer(this.gridPanel, this.gc));
        this.placementHistoryLayer = new PlacementHistory(this.gridPanel, this.gc);
        this.gridPanel.addLayer(this.placementHistoryLayer, false);
        this.eventsOverlayPanel = new EventsOverlayLayer(this.gridPanel, this.gc);
        this.gridPanel.addLayer(this.eventsOverlayPanel, true);
        this.gridPanel.getEventsPanel().setEventsOverlayPanel(this.eventsOverlayPanel);
        this.add(this.gridPanel);
    }

    public GridPanel getGridPanel() {
        return this.gridPanel;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void setShowFarmHints(boolean showFarmHints) {
        if (showFarmHints) {
            this.getGridPanel().showLayer(this.farmHintLayer);
        } else {
            this.getGridPanel().hideLayer(this.farmHintLayer);
        }
    }

    public void toggleRecentHistory(boolean show) {
        if (show) {
            this.gridPanel.showLayer(this.placementHistoryLayer);
        } else {
            this.gridPanel.hideLayer(this.placementHistoryLayer);
        }
    }

    public void closeGame() {
        this.gridPanel.clearActionDecorations();
        this.gridPanel.hideLayer(TilePlacementLayer.class);
        this.gridPanel.removeInteractionPanels();
    }
}

