/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.actionpanel;

import com.jcloisterzone.action.FlockAction;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.grid.actionpanel.ActionInteractionPanel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.wsio.message.FlockMessage;
import io.vavr.collection.Map;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Function;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class FlockPanel
extends ActionInteractionPanel<FlockAction> {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private JButton expandOption;
    private JButton scoreOption;

    public FlockPanel(Client client, final GameController gc) {
        super(client, gc);
        Image image;
        this.setOpaque(true);
        this.setBackground(gc.getClient().getTheme().getTransparentPanelBg());
        this.setLayout(new MigLayout("ins 10 20 10 20", "[grow]", ""));
        ThemedJLabel label = new ThemedJLabel(I18nUtils._tr("Shepherd", new Object[0]));
        label.setFont(FONT_HEADER);
        label.setForeground(gc.getClient().getTheme().getHeaderFontColor());
        this.add((Component)label, "wrap, gapbottom 10");
        label = new ThemedJLabel(I18nUtils._tr("Farm with shepherd was expanded.", new Object[0]));
        this.add((Component)label, "wrap, gapbottom 5");
        GameState state = gc.getGame().getState();
        Shepherd shepherd = (Shepherd)state.getTurnPlayer().getSpecialMeeples(state).find(m -> m instanceof Shepherd).getOrNull();
        FeaturePointer shepherdFp = shepherd.getDeployment(state);
        Farm farm = (Farm)state.getFeature(shepherdFp);
        Map shephersOnFarm = state.getDeployedMeeples().filter((m, fp) -> m instanceof Shepherd && farm.getPlaces().contains((FeaturePointer)fp));
        int i = 0;
        JPanel farmContent = new JPanel();
        farmContent.setOpaque(true);
        farmContent.setBackground(TRANSPARENT);
        farmContent.setLayout(new MigLayout("ins 5 5 5 5", "[][][][][]", ""));
        for (Meeple m2 : shephersOnFarm.keySet()) {
            Color color = m2.getPlayer().getColors().getMeepleColor();
            LayeredImageDescriptor lid = new LayeredImageDescriptor(m2.getClass(), color);
            image = client.getResourceManager().getLayeredImage(lid);
            farmContent.add((Component)this.createIconLabel(image), ++i % 5 == 0 ? "wrap" : "");
        }
        Map placedTokens = (Map)state.getCapabilityModel(SheepCapability.class);
        int points = 0;
        for (SheepCapability.SheepToken token : shephersOnFarm.values().flatMap(fp -> (Iterable)placedTokens.get(fp).get())) {
            points += token.sheepCount();
            image = client.getResourceManager().getImage("neutral/" + token.name().toLowerCase());
            farmContent.add((Component)this.createIconLabel(image), ++i % 5 == 0 ? "wrap" : "");
        }
        this.add((Component)farmContent, "wrap, gapbottom 5");
        label = new ThemedJLabel(I18nUtils._tr("You can draw another sheep/wolf token from a bag.", new Object[0]));
        this.add((Component)label, "wrap, gapbottom 0");
        int remainingTokens = SheepCapability.TOKENS_COUNT - placedTokens.values().flatMap(Function.identity()).length();
        label = new ThemedJLabel(I18nUtils._tr("({0} tokens left in bag)", remainingTokens));
        this.add((Component)label, "wrap, gapbottom 5");
        boolean isActive = gc.getGame().getState().getActivePlayer().isLocalHuman();
        this.expandOption = new JButton();
        this.expandOption.setText(I18nUtils._tr("Expand the flock of sheep.", new Object[0]));
        this.expandOption.setEnabled(isActive);
        this.expandOption.addActionListener(new ActionListener(){
            final /* synthetic */ FlockPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                gc.getConnection().send(new FlockMessage(FlockMessage.FlockOption.EXPAND));
            }
        });
        this.add((Component)this.expandOption, "wrap, growx, h 40, gapbottom 5");
        label = new ThemedJLabel(I18nUtils._tr("Or score the flock for {0} points.", points));
        this.add((Component)label, "wrap, gapbottom 5");
        this.scoreOption = new JButton();
        this.scoreOption.setText(I18nUtils._tr("Herd the flock into the stable.", new Object[0]));
        this.scoreOption.setEnabled(isActive);
        this.scoreOption.addActionListener(new ActionListener(){
            final /* synthetic */ FlockPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                gc.getConnection().send(new FlockMessage(FlockMessage.FlockOption.SCORE));
            }
        });
        this.add((Component)this.scoreOption, "wrap, growx, h 40, gapbottom 5");
    }

    private JLabel createIconLabel(Image image) {
        image = image.getScaledInstance(40, 40, 4);
        JLabel icon = new JLabel(new ImageIcon(image));
        icon.setOpaque(true);
        icon.setBackground(TRANSPARENT);
        return icon;
    }
}

