/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.controls.action.ActionWrapper;
import com.jcloisterzone.ui.grid.ActionLayer;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputAdapter;

public abstract class AbstractAreaLayer
extends AbstractGridLayer
implements ActionLayer {
    private static final AlphaComposite AREA_ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.6f);
    private static final AlphaComposite FIGURE_HIGHLIGHT_AREA_ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.75f);
    private Player player;
    private ActionWrapper actionWrapper;
    private Map<BoardPointer, FeatureArea> areas;
    private Map<BoardPointer, FeatureArea> scaledAreas;
    private FeatureArea selectedArea;
    private BoardPointer selectedFeaturePointer;
    boolean refreshAreas;
    private boolean figureHighlight = false;

    public AbstractAreaLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
        Config.DebugConfig debugConfig = this.getClient().getConfig().getDebug();
        if (debugConfig != null && "figure".equals(debugConfig.getArea_highlight())) {
            this.figureHighlight = true;
        }
    }

    @Override
    public void setActionWrapper(boolean active, ActionWrapper actionWrapper) {
        this.actionWrapper = actionWrapper;
        if (actionWrapper == null) {
            this.cleanAreas();
        } else {
            this.areas = this.prepareAreas();
        }
    }

    @Override
    public ActionWrapper getActionWrapper() {
        return this.actionWrapper;
    }

    @Override
    public void onShow() {
        super.onShow();
        this.player = this.getGame().getState().getActivePlayer();
        this.attachMouseInputListener(new AreaLayerMouseMotionListener());
    }

    @Override
    public void onHide() {
        super.onHide();
        this.player = null;
        this.cleanAreas();
    }

    protected Map<BoardPointer, FeatureArea> scaleAreas() {
        return this.areas.mapValues(fa -> fa.transform(this.getZoomScale()));
    }

    private void cleanAreas() {
        this.areas = null;
        this.scaledAreas = null;
        this.selectedFeaturePointer = null;
        this.selectedArea = null;
    }

    @Override
    public void zoomChanged(int squareSize) {
        this.scaledAreas = null;
        super.zoomChanged(squareSize);
    }

    protected abstract Map<BoardPointer, FeatureArea> prepareAreas();

    protected abstract void performAction(BoardPointer var1);

    @Override
    public void paint(Graphics2D g2) {
        if (this.selectedArea != null) {
            Composite old = g2.getComposite();
            if (this.figureHighlight && this.selectedFeaturePointer instanceof FeaturePointer) {
                this.paintFigureHighlight(g2);
            } else {
                this.paintAreaHighlight(g2);
            }
            g2.setComposite(old);
        }
    }

    private void paintFigureHighlight(Graphics2D g2) {
        GameState state = this.getGame().getState();
        FeaturePointer fp = (FeaturePointer)this.selectedFeaturePointer;
        Position pos = fp.getPosition();
        g2.setComposite(FIGURE_HIGHLIGHT_AREA_ALPHA_COMPOSITE);
        PlacedTile placedTile = state.getPlacedTile(pos);
        ImmutablePoint point = this.rm.getMeeplePlacement(placedTile.getTile(), placedTile.getRotation(), fp.getLocation());
        Player p = state.getActivePlayer();
        Image unscaled = this.rm.getLayeredImage(new LayeredImageDescriptor(SmallFollower.class, p.getColors().getMeepleColor()));
        int size = (int)((double)this.getTileWidth() * (double)0.35f);
        Image scaled = unscaled.getScaledInstance(size, size, 4);
        scaled = new ImageIcon(scaled).getImage();
        ImmutablePoint scaledOffset = point.scale(this.getTileWidth(), this.getTileHeight(), size);
        g2.drawImage(scaled, this.getOffsetX(pos) + scaledOffset.getX(), this.getOffsetY(pos) + scaledOffset.getY(), this.gridPanel);
    }

    private void paintAreaHighlight(Graphics2D g2) {
        GameState state = this.getGame().getState();
        Player p = state.getActivePlayer();
        if (p != null && p.equals(this.player)) {
            Color color = this.selectedArea.getForceAreaColor();
            g2.setColor(color == null ? p.getColors().getMeepleColor() : color);
            g2.setComposite(AREA_ALPHA_COMPOSITE);
            g2.fill(this.selectedArea.getDisplayArea());
        }
    }

    class AreaLayerMouseMotionListener
    extends MouseInputAdapter {
        AreaLayerMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean doSwap;
            if (AbstractAreaLayer.this.scaledAreas == null) {
                AbstractAreaLayer.this.scaledAreas = AbstractAreaLayer.this.scaleAreas();
            }
            FeatureArea swap = null;
            Object swapPointer = null;
            Point2D point = AbstractAreaLayer.this.gridPanel.getRelativePoint(e.getPoint());
            int x = (int)point.getX();
            int y = (int)point.getY();
            for (Tuple2 entry : AbstractAreaLayer.this.scaledAreas) {
                FeatureArea fa = (FeatureArea)entry._2;
                if (!fa.getTrackingArea().contains(x, y)) continue;
                if (swap == null) {
                    swap = fa;
                    swapPointer = (BoardPointer)entry._1;
                    continue;
                }
                if (swap.getzIndex() == fa.getzIndex()) {
                    swap = null;
                    swapPointer = null;
                    break;
                }
                if (fa.getzIndex() <= swap.getzIndex()) continue;
                swap = fa;
                swapPointer = (BoardPointer)entry._1;
            }
            boolean bl = doSwap = swapPointer == null && AbstractAreaLayer.this.selectedFeaturePointer != null || swapPointer != null && !swapPointer.equals(AbstractAreaLayer.this.selectedFeaturePointer);
            if (doSwap || AbstractAreaLayer.this.refreshAreas) {
                AbstractAreaLayer.this.selectedArea = swap;
                AbstractAreaLayer.this.selectedFeaturePointer = (BoardPointer)swapPointer;
                AbstractAreaLayer.this.gridPanel.repaint();
                AbstractAreaLayer.this.refreshAreas = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && AbstractAreaLayer.this.selectedArea != null) {
                AbstractAreaLayer.this.performAction(AbstractAreaLayer.this.selectedFeaturePointer);
                e.consume();
            }
        }
    }
}

