/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.grid.DragInsensitiveMouseClickListener;
import com.jcloisterzone.ui.grid.GridLayer;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.resources.ConvenientResourceManager;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.TileImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.event.MouseInputListener;

public abstract class AbstractGridLayer
implements GridLayer,
UIEventListener {
    protected boolean visible;
    protected final GridPanel gridPanel;
    protected final GameController gc;
    protected final ConvenientResourceManager rm;
    private MouseInputListener mouseListener;

    public AbstractGridLayer(GridPanel gridPanel, GameController gc) {
        this.gridPanel = gridPanel;
        this.gc = gc;
        this.rm = gc.getClient().getResourceManager();
    }

    private void triggerFakeMouseEvent() {
        Point pt = this.gridPanel.getMousePosition();
        if (pt != null) {
            this.mouseListener.mouseMoved(new MouseEvent(this.gridPanel, 0, System.currentTimeMillis(), 0, pt.x, pt.y, -1, -1, 0, false, 0));
        }
    }

    @Override
    public void zoomChanged(int squareSize) {
        if (this.mouseListener != null) {
            this.triggerFakeMouseEvent();
        }
    }

    @Override
    public void boardRotated(Rotation boardRotation) {
        if (this.mouseListener != null) {
            this.triggerFakeMouseEvent();
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void attachMouseInputListener(MouseInputListener mouseListener) {
        assert (this.mouseListener == null);
        this.mouseListener = new DragInsensitiveMouseClickListener(mouseListener);
        this.gridPanel.addMouseListener(this.mouseListener);
        this.gridPanel.addMouseMotionListener(this.mouseListener);
        this.triggerFakeMouseEvent();
    }

    @Override
    public void onShow() {
        assert (!this.visible);
        this.visible = true;
    }

    @Override
    public void onHide() {
        assert (this.visible);
        this.visible = false;
        if (this.mouseListener != null) {
            this.gridPanel.removeMouseMotionListener(this.mouseListener);
            this.gridPanel.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    public AffineTransform getAffineTransform(TileImage tileImage, Position pos) {
        Insets offset = tileImage.getOffset();
        Image img = tileImage.getImage();
        int w = img.getWidth(null) - offset.left - offset.right;
        int h = img.getHeight(null) - offset.top - offset.bottom;
        return this.getAffineTransform(w, h, pos, offset);
    }

    public AffineTransform getAffineTransform(int fromWidth, int fromHeight, Position pos, Insets offset) {
        AffineTransform t = this.getAffineTransform(fromWidth, fromHeight, pos, Rotation.R0);
        t.concatenate(AffineTransform.getTranslateInstance(-offset.left, -offset.top));
        return t;
    }

    public AffineTransform getAffineTransform(int fromWidth, int fromHeight, Position pos) {
        return this.getAffineTransform(fromWidth, fromHeight, pos, Rotation.R0);
    }

    public AffineTransform getAffineTransform(Position pos) {
        return AffineTransform.getTranslateInstance(pos.x * this.getTileWidth(), pos.y * this.getTileHeight());
    }

    public AffineTransform getAffineTransform(Position pos, Rotation rotation) {
        AffineTransform r = rotation == Rotation.R0 || rotation == Rotation.R180 ? rotation.getAffineTransform(this.getTileWidth(), this.getTileHeight()) : rotation.getAffineTransform(this.getTileHeight(), this.getTileWidth());
        AffineTransform t = AffineTransform.getTranslateInstance(this.getOffsetX(pos), this.getOffsetY(pos));
        t.concatenate(r);
        return t;
    }

    @Deprecated
    private AffineTransform getAffineTransform(int fromWidth, int fromHeight, Position pos, Rotation rotation) {
        double ratioY;
        double ratioX;
        if (rotation == Rotation.R0 || rotation == Rotation.R180) {
            ratioX = (double)this.getTileWidth() / (double)fromWidth;
            ratioY = (double)this.getTileHeight() / (double)fromHeight;
        } else {
            ratioX = (double)this.getTileHeight() / (double)fromWidth;
            ratioY = (double)this.getTileWidth() / (double)fromHeight;
        }
        return this.getAffineTransform(pos, rotation, ratioX, ratioY);
    }

    public AffineTransform getAffineTransform(Position pos, Rotation rotation, double ratioX, double ratioY) {
        AffineTransform t = this.getAffineTransform(pos, rotation);
        AffineTransform scale = AffineTransform.getScaleInstance(ratioX, ratioY);
        t.concatenate(scale);
        return t;
    }

    protected AffineTransform getAffineTransformIgnoringRotation(Position pos) {
        int x = this.getOffsetX(pos);
        int y = this.getOffsetY(pos);
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.concatenate(this.gridPanel.getBoardRotation().inverse().getAffineTransform(this.getTileWidth(), this.getTileHeight()));
        return at;
    }

    protected void drawImageIgnoringRotation(Graphics2D g2, Image img, Position pos, int tx, int ty, int width, int height) {
        AffineTransform at = this.getAffineTransformIgnoringRotation(pos);
        at.concatenate(AffineTransform.getTranslateInstance(tx, ty));
        at.concatenate(AffineTransform.getScaleInstance((double)width / (double)img.getWidth(null), (double)height / (double)img.getHeight(null)));
        g2.drawImage(img, at, null);
    }

    public int getOffsetX(Position pos) {
        return this.getTileWidth() * pos.x;
    }

    public int getOffsetY(Position pos) {
        return this.getTileHeight() * pos.y;
    }

    public AffineTransform getZoomScale() {
        double ratioX = (double)this.gridPanel.getTileWidth() / 1000.0;
        double ratioY = (double)this.gridPanel.getTileHeight() / 1000.0;
        return AffineTransform.getScaleInstance(ratioX, ratioY);
    }

    @Deprecated
    public AffineTransform getPointZoomScale() {
        double ratioX = (double)this.gridPanel.getTileWidth() / 100.0;
        double ratioY = (double)this.gridPanel.getTileHeight() / 100.0;
        return AffineTransform.getScaleInstance(ratioX, ratioY);
    }

    public int getTileWidth() {
        return this.gridPanel.getTileWidth();
    }

    public int getTileHeight() {
        return this.gridPanel.getTileHeight();
    }

    protected Client getClient() {
        return this.gridPanel.getClient();
    }

    protected Game getGame() {
        return this.gc.getGame();
    }

    protected Config getConfig() {
        return this.gc.getConfig();
    }

    @Deprecated
    protected Area transformArea(Area area, Position pos) {
        return area.createTransformedArea(this.getAffineTransform(pos));
    }

    @Deprecated
    private int scale(int x) {
        return (int)((double)this.getTileWidth() * ((double)x / 100.0));
    }

    @Deprecated
    private Font getFont(int relativeSize) {
        int realSize = this.scale(relativeSize);
        return new Font(null, 1, realSize);
    }

    public void drawAntialiasedTextCentered(Graphics2D g2, String text, int fontSize, Position pos, ImmutablePoint centerNoScaled, Color fgColor, Color bgColor) {
        ImmutablePoint center = centerNoScaled.scale(this.getTileWidth(), this.getTileHeight());
        this.drawAntialiasedTextCenteredNoScale(g2, text, fontSize, pos, center, fgColor, bgColor);
    }

    public void drawAntialiasedTextCenteredNoScale(Graphics2D g2, String text, int fontSize, Position pos, ImmutablePoint center, Color fgColor, Color bgColor) {
        Color original = g2.getColor();
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(text, this.getFont(fontSize), frc);
        Rectangle2D bounds = tl.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        center = center.translate(-w / 2, -h / 2);
        int x = this.getOffsetX(pos) + center.getX();
        int y = this.getOffsetY(pos) + center.getY();
        AffineTransform orig = g2.getTransform();
        g2.rotate(-this.gridPanel.getBoardRotation().getTheta(), x + w / 2, y + h / 2);
        if (bgColor != null) {
            g2.setColor(bgColor);
            g2.fillRect(x - 6, y - 5, w + 12, h + 10);
        }
        g2.setColor(fgColor);
        tl.draw(g2, x, y + h);
        g2.setColor(original);
        g2.setTransform(orig);
    }

    protected Area getFeatureArea(GameState state, Feature f) {
        Area area = new Area();
        for (FeaturePointer fp : f.getPlaces()) {
            Position pos = fp.getPosition();
            Location loc = fp.getLocation();
            PlacedTile pt = state.getPlacedTile(pos);
            FeatureArea fa = this.rm.getFeatureArea(pt.getTile(), pt.getRotation(), loc).translateTo(pos);
            area.add(fa.getDisplayArea());
        }
        return area;
    }
}

