/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.FlierRollEvent;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.event.play.TilePlacedEvent;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.animation.Animation;
import com.jcloisterzone.ui.animation.AnimationService;
import com.jcloisterzone.ui.animation.FlierDiceRollAnimation;
import com.jcloisterzone.ui.animation.RecentPlacement;
import com.jcloisterzone.ui.animation.ScoreAnimation;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import java.awt.Graphics2D;

public class AnimationLayer
extends AbstractGridLayer {
    private final AnimationService service = new AnimationService();

    public AnimationLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
        this.service.setGridPanel(gridPanel);
        this.service.start();
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        for (PlayEvent pe : ev.getNewPlayEvents()) {
            if (pe instanceof ScoreEvent) {
                this.onScoreEvent((ScoreEvent)pe);
            }
            if (pe instanceof TilePlacedEvent) {
                this.onTilePlacedEvent((TilePlacedEvent)pe);
            }
            if (!(pe instanceof FlierRollEvent)) continue;
            this.onFlierRollEvent((FlierRollEvent)pe);
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        for (Animation a : this.service.getAnimations()) {
            if (a instanceof ScoreAnimation) continue;
            a.paint(this, g2);
        }
        for (Animation a : this.service.getAnimations()) {
            if (!(a instanceof ScoreAnimation)) continue;
            a.paint(this, g2);
        }
    }

    public void onFlierRollEvent(FlierRollEvent ev) {
        this.service.registerAnimation(new FlierDiceRollAnimation(ev.getPosition(), ev.getDistance()));
    }

    public void onScoreEvent(ScoreEvent ev) {
        if (ev.getFeaturePointer() == null) {
            this.scored(ev.getPosition(), ev.getReceiver(), ev.getLabel(), ev.isFinal());
        } else {
            this.scored(ev.getFeaturePointer(), ev.getReceiver(), ev.getLabel(), ev.getMeeple().getClass(), ev.isFinal());
        }
    }

    public void onTilePlacedEvent(TilePlacedEvent ev) {
        Player p;
        boolean initialPlacement;
        Position pos = ev.getPosition();
        boolean bl = initialPlacement = ev.getMetadata().getTriggeringPlayerIndex() == null;
        if (!initialPlacement && !(p = this.getGame().getState().getPlayers().getPlayer(ev.getMetadata().getTriggeringPlayerIndex())).isLocalHuman()) {
            this.service.registerAnimation(new RecentPlacement(pos));
        }
    }

    private Integer getScoreAnimationDuration() {
        Integer duration = this.getClient().getConfig().getScore_display_duration();
        return duration == null ? 10 : Math.max(duration, 1);
    }

    private void scored(FeaturePointer fp, Player player, String points, Class<? extends Meeple> meepleType, boolean finalScoring) {
        ImmutablePoint offset;
        Position pos = fp.getPosition();
        if (Barn.class.equals(meepleType)) {
            offset = this.rm.getBarnPlacement();
        } else {
            PlacedTile pt = this.gc.getGame().getState().getPlacedTile(fp.getPosition());
            offset = this.rm.getMeeplePlacement(pt.getTile(), pt.getRotation(), fp.getLocation());
        }
        this.service.registerAnimation(new ScoreAnimation(pos, points, offset, player.getColors().getMeepleColor(), finalScoring ? null : this.getScoreAnimationDuration()));
    }

    private void scored(Position pos, Player player, String points, boolean finalScoring) {
        this.service.registerAnimation(new ScoreAnimation(pos, points, new ImmutablePoint(50, 50), player.getColors().getMeepleColor(), finalScoring ? null : this.getScoreAnimationDuration()));
    }
}

