/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.grid.layer.TextureFactory;
import com.jcloisterzone.ui.resources.ConvenientResourceManager;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmHintsLayer
extends AbstractGridLayer {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final AlphaComposite HINT_ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.4f);
    private FarmHintsLayerModel model = new FarmHintsLayerModel();

    public FarmHintsLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        if (ev.hasMeeplesChanged() || ev.hasPlacedTilesChanged()) {
            this.model = this.createModel(ev.getCurrentState());
            this.gridPanel.repaint();
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        if (!this.visible) {
            return;
        }
        Composite old = g2.getComposite();
        g2.setComposite(HINT_ALPHA_COMPOSITE);
        TextureFactory textures = new TextureFactory(this.getTileWidth());
        for (FarmHint fh : this.model.hints) {
            if (fh.scaledArea == null) {
                fh.scaledArea = fh.area.createTransformedArea(this.getZoomScale());
            }
            if (fh.colors.length() > 1) {
                g2.setPaint(textures.createMultiColor(fh.colors.toJavaArray(Color.class)));
            } else {
                g2.setPaint(textures.create((Color)fh.colors.get()));
            }
            g2.fill(fh.scaledArea);
        }
        g2.setPaint(null);
        g2.setComposite(old);
    }

    private FarmHintsLayerModel createModel(GameState state) {
        ConvenientResourceManager rm = this.gc.getClient().getResourceManager();
        FarmHintsLayerModel model = new FarmHintsLayerModel();
        model.hints = state.getFeatures(Farm.class).map(farm -> new Tuple2<Farm, Set<Player>>((Farm)farm, farm.getOwners(state))).map(t -> {
            Set barnOwners;
            if (((Set)t._2).isEmpty() && !(barnOwners = ((Farm)t._1).getSpecialMeeples(state).filter(m -> m instanceof Barn).map(m -> m.getPlayer()).toSet()).isEmpty()) {
                return new Tuple2((Farm)t._1, barnOwners);
            }
            return t;
        }).filter(t -> {
            Farm farm = (Farm)t._1;
            if (((Set)t._2).isEmpty()) {
                boolean hasCity = !farm.getAdjoiningCities().isEmpty() || farm.isAdjoiningCityOfCarcassonne();
                return farm.getPlaces().size() > 1 && hasCity;
            }
            return true;
        }).map(t -> {
            Farm farm = (Farm)t._1;
            Area area = this.getFeatureArea(state, farm);
            List<Color> colors = ((Set)t._2).isEmpty() ? List.of(Color.DARK_GRAY) : Stream.ofAll((Iterable)t._2).map(p -> p.getColors().getMeepleColor()).toList();
            return new FarmHint(farm, area, colors);
        }).toList();
        return model;
    }

    @Override
    public void zoomChanged(int squareSize) {
        for (FarmHint fh : this.model.hints) {
            fh.scaledArea = null;
        }
    }

    static class FarmHintsLayerModel {
        List<FarmHint> hints = List.empty();

        FarmHintsLayerModel() {
        }
    }

    static class FarmHint {
        public Farm farm;
        public Area area;
        public Area scaledArea;
        public List<Color> colors;

        public FarmHint(Farm farm, Area area, List<Color> colors) {
            this.farm = farm;
            this.area = area;
            this.colors = colors;
        }
    }
}

