/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.action.BridgeAction;
import com.jcloisterzone.action.FerriesAction;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.SelectFeatureAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractAreaLayer;
import com.jcloisterzone.ui.resources.FeatureArea;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JOptionPane;

public class FeatureAreaLayer
extends AbstractAreaLayer {
    private static Area NS_FERRY = new Area(new Rectangle(400, 50, 160, 900));
    private static Area NW_FERRY = new Area(new Rectangle(0, 0, 160, 707));

    public FeatureAreaLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    public SelectFeatureAction getAction() {
        return (SelectFeatureAction)super.getAction();
    }

    public Area getFerryArea(Location loc) {
        Rotation rot = loc.getRotationOf(Location.NS);
        if (rot != null) {
            Area a = new Area(NS_FERRY);
            a.transform(rot.getAffineTransform(1000));
            return a;
        }
        rot = loc.getRotationOf(Location.NW);
        if (rot != null) {
            Area a = new Area(NW_FERRY);
            a.transform(rot.getAffineTransform(1000));
            return a;
        }
        throw new IllegalArgumentException("Incorrect location");
    }

    @Override
    protected Map<BoardPointer, FeatureArea> prepareAreas() {
        SelectFeatureAction action = this.getAction();
        return action.getOptions().toMap(fp -> {
            FeatureArea fa;
            Location loc = fp.getLocation();
            if (action instanceof BridgeAction) {
                fa = this.rm.getBridgeArea(loc);
            } else if (action instanceof FerriesAction) {
                fa = new FeatureArea(this.getFerryArea(loc), 30);
                fa = fa.setForceAreaColor(new Color(253, 241, 215));
            } else if (action instanceof MeepleAction && ((MeepleAction)action).getMeepleType().equals(Barn.class)) {
                fa = this.rm.getBarnArea();
            } else {
                PlacedTile pt = this.gc.getGame().getState().getPlacedTile(fp.getPosition());
                fa = this.rm.getFeatureArea(pt.getTile(), pt.getRotation(), loc);
            }
            return new Tuple2<FeaturePointer, FeatureArea>((FeaturePointer)fp, fa.translateTo(fp.getPosition()));
        });
    }

    private Set<Location> getMonasteryOptions(Position pos) {
        return this.getAction().getOptions().filter(fp -> fp.getPosition() == pos).map(FeaturePointer::getLocation).filter(loc -> loc == Location.CLOISTER || loc == Location.MONASTERY);
    }

    @Override
    protected void performAction(BoardPointer ptr) {
        SelectFeatureAction action = this.getAction();
        FeaturePointer fp = (FeaturePointer)ptr;
        Position pos = fp.getPosition();
        if (this.gc.getActionLock().get()) {
            return;
        }
        if (action instanceof MeepleAction) {
            Set<Location> monasteryOptions;
            boolean isMonasteryLocataion;
            boolean bl = isMonasteryLocataion = fp.getLocation() == Location.CLOISTER || fp.getLocation() == Location.MONASTERY;
            if (isMonasteryLocataion && (monasteryOptions = this.getMonasteryOptions(pos)).contains(Location.MONASTERY)) {
                boolean abbotOnly = !monasteryOptions.contains(Location.CLOISTER);
                Object[] dialogOptions = abbotOnly ? new String[]{I18nUtils._tr("Place as abbot", new Object[0])} : new String[]{I18nUtils._tr("Place as monk", new Object[0]), I18nUtils._tr("Place as abbot", new Object[0])};
                int result = JOptionPane.showOptionDialog(this.getClient(), I18nUtils._tr("How do you want to place follower on monastery?", new Object[0]), I18nUtils._tr("Monastery", new Object[0]), 0, 3, null, dialogOptions, dialogOptions[0]);
                if (result == -1) {
                    return;
                }
                if (abbotOnly || result == 1) {
                    fp = new FeaturePointer(pos, Location.MONASTERY);
                }
            }
        }
        this.gc.getConnection().send(action.select(fp));
    }

    static {
        NW_FERRY.transform(AffineTransform.getRotateInstance(0.7853981633974483));
        NW_FERRY.transform(AffineTransform.getTranslateInstance(510.0, 10.0));
    }
}

