/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.action.LittleBuildingAction;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.controls.action.ActionWrapper;
import com.jcloisterzone.ui.grid.ActionLayer;
import com.jcloisterzone.ui.grid.GridMouseAdapter;
import com.jcloisterzone.ui.grid.GridMouseListener;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class LittleBuildingActionLayer
extends AbstractGridLayer
implements ActionLayer,
GridMouseListener {
    protected static final Composite SHADOW_COMPOSITE = AlphaComposite.getInstance(3, 0.4f);
    private static final double PADDING_RATIO = 0.1;
    private Map<Token, Image> images = new HashMap<Token, Image>();
    private ActionWrapper actionWrapper;
    private LittleBuildingsCapability.LittleBuilding selected = null;
    private HashMap<LittleBuildingsCapability.LittleBuilding, Rectangle> areas = new HashMap();
    int icoSize;
    int padding;

    public LittleBuildingActionLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
        this.images.put(LittleBuildingsCapability.LittleBuilding.LB_SHED, this.rm.getImage("neutral/lb_shed"));
        this.images.put(LittleBuildingsCapability.LittleBuilding.LB_HOUSE, this.rm.getImage("neutral/lb_house"));
        this.images.put(LittleBuildingsCapability.LittleBuilding.LB_TOWER, this.rm.getImage("neutral/lb_tower"));
        this.recomputeDimenensions(this.getTileWidth());
    }

    @Override
    public void setActionWrapper(boolean active, ActionWrapper actionWrapper) {
        this.actionWrapper = actionWrapper;
        if (active) {
            this.prepareAreas();
        } else {
            this.selected = null;
            this.areas.clear();
        }
    }

    @Override
    public ActionWrapper getActionWrapper() {
        return this.actionWrapper;
    }

    public LittleBuildingAction getAction() {
        return this.actionWrapper == null ? null : (LittleBuildingAction)this.actionWrapper.getAction();
    }

    private void recomputeDimenensions(int tileWidth) {
        this.icoSize = tileWidth / 2;
        this.padding = (int)((double)this.icoSize * 0.1);
    }

    @Override
    public void zoomChanged(int tileWidth) {
        this.recomputeDimenensions(tileWidth);
        this.areas.clear();
        this.prepareAreas();
        super.zoomChanged(tileWidth);
    }

    @Override
    public void boardRotated(Rotation boardRotation) {
        this.areas.clear();
        this.prepareAreas();
        super.boardRotated(boardRotation);
    }

    private int getIconX(LittleBuildingsCapability.LittleBuilding lb) {
        int x = -this.icoSize / 2 - this.padding * 3;
        return x + lb.ordinal() * (this.icoSize + 3 * this.padding);
    }

    private int getIconY(LittleBuildingsCapability.LittleBuilding lb) {
        return -this.icoSize / 2;
    }

    private void prepareAreas() {
        LittleBuildingAction action = this.getAction();
        if (action == null) {
            return;
        }
        Position pos = action.getPosition();
        AffineTransform at = this.getAffineTransformIgnoringRotation(pos);
        for (LittleBuildingsCapability.LittleBuilding lb : LittleBuildingsCapability.LittleBuilding.values()) {
            if (!action.getOptions().contains(lb)) continue;
            int x = this.getIconX(lb);
            int y = this.getIconY(lb);
            Rectangle rect = new Rectangle(x - this.padding, y - this.padding, this.icoSize + 2 * this.padding, this.icoSize + 2 * this.padding);
            this.areas.put(lb, at.createTransformedShape(rect).getBounds());
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        LittleBuildingAction action = this.getAction();
        Position pos = action.getPosition();
        Composite origComposite = g2.getComposite();
        ImmutablePoint shadowOffset = new ImmutablePoint(3, 3);
        shadowOffset = shadowOffset.rotate(this.gridPanel.getBoardRotation().inverse());
        for (LittleBuildingsCapability.LittleBuilding lb : LittleBuildingsCapability.LittleBuilding.values()) {
            Rectangle r = this.areas.get(lb);
            if (r == null) continue;
            g2.setComposite(SHADOW_COMPOSITE);
            g2.setColor(Color.BLACK);
            g2.fillRect(r.x + shadowOffset.getX(), r.y + shadowOffset.getY(), r.width, r.height);
            g2.setComposite(origComposite);
            g2.setColor(this.selected == lb ? Color.WHITE : Color.GRAY);
            g2.fill(r);
            Image img = this.images.get(lb);
            int x = this.getIconX(lb);
            int y = this.getIconY(lb);
            AffineTransform at = this.getAffineTransform(pos, this.gridPanel.getBoardRotation().inverse());
            at.concatenate(AffineTransform.getTranslateInstance(x, y));
            at.concatenate(AffineTransform.getScaleInstance((double)this.icoSize / (double)img.getWidth(null), (double)this.icoSize / (double)img.getHeight(null)));
            g2.drawImage(this.images.get(lb), at, null);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e, Position p) {
        Point2D point = this.gridPanel.getRelativePoint(e.getPoint());
        int x = (int)point.getX();
        int y = (int)point.getY();
        LittleBuildingsCapability.LittleBuilding newValue = null;
        for (Map.Entry<LittleBuildingsCapability.LittleBuilding, Rectangle> entry : this.areas.entrySet()) {
            if (!entry.getValue().contains(x, y)) continue;
            newValue = entry.getKey();
            break;
        }
        if (newValue != this.selected) {
            this.selected = newValue;
            this.gridPanel.repaint();
        }
    }

    @Override
    public void onShow() {
        super.onShow();
        this.attachMouseInputListener(new GridMouseAdapter(this.gridPanel, this));
    }

    @Override
    public void tileEntered(MouseEvent e, Position p) {
    }

    @Override
    public void tileExited(MouseEvent e, Position p) {
    }

    @Override
    public void mouseClicked(MouseEvent e, Position p) {
        if (e.getButton() == 1 && this.selected != null) {
            e.consume();
            if (!this.gc.getActionLock().get()) {
                this.gc.getConnection().send(this.getAction().select(this.selected));
            }
        }
    }
}

