/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Figure;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.neutral.Count;
import com.jcloisterzone.figure.neutral.Fairy;
import com.jcloisterzone.figure.neutral.Mage;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.figure.neutral.Witch;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.grid.layer.FigureImage;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import io.vavr.Tuple2;
import io.vavr.collection.Stream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class MeepleLayer
extends AbstractGridLayer {
    public static final double FIGURE_SIZE_RATIO = (double)0.35f;
    private MeppleLayerModel model = new MeppleLayerModel();

    public MeepleLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        if (ev.hasMeeplesChanged() || ev.hasNeutralFiguresChanged()) {
            this.model = this.createModel(ev.getCurrentState());
            this.gridPanel.repaint();
        }
    }

    private MeppleLayerModel createModel(GameState state) {
        MeppleLayerModel model = new MeppleLayerModel();
        HashMap<FeaturePointer, LinkedList> onFeature = new HashMap<FeaturePointer, LinkedList>();
        LinkedList<Tuple2<Position, NeutralFigure>> onTile = new LinkedList<Tuple2<Position, NeutralFigure>>();
        for (Tuple2 tuple2 : state.getDeployedMeeples()) {
            LinkedList<Figure> list2 = (LinkedList<Figure>)onFeature.get(tuple2._2);
            if (list2 == null) {
                list2 = new LinkedList<Figure>();
                onFeature.put((FeaturePointer)tuple2._2, list2);
            }
            list2.add((Figure)tuple2._1);
        }
        for (Tuple2 tuple2 : state.getNeutralFigures().getDeployedNeutralFigures()) {
            if (tuple2._2 instanceof Position) {
                onTile.add(new Tuple2<Position, NeutralFigure>((Position)tuple2._2, (NeutralFigure)tuple2._1));
                continue;
            }
            FeaturePointer fp2 = ((BoardPointer)tuple2._2).asFeaturePointer();
            LinkedList<Figure> list3 = (LinkedList<Figure>)onFeature.get(fp2);
            if (list3 == null) {
                list3 = new LinkedList<Figure>();
                onFeature.put(fp2, list3);
            }
            list3.add((Figure)tuple2._1);
        }
        onFeature.forEach((fp, list) -> {
            LinkedList cloisterMeeples;
            int order = 0;
            if (fp.getLocation() == Location.MONASTERY && (cloisterMeeples = (LinkedList)onFeature.get(fp.setLocation(Location.CLOISTER))) != null) {
                order += cloisterMeeples.size();
            }
            for (Figure fig : list) {
                PlacedTile placedTile = state.getPlacedTile(fp.getPosition());
                FigureImage fi = new FigureImage(fig);
                fi.offset = this.getFigureOffset(placedTile, fig, (BoardPointer)fp);
                if (order > 0) {
                    fi.offset = fi.offset.add(10 * order, 0);
                }
                this.initFigureImage(fi, placedTile, fig, (BoardPointer)fp);
                if (placedTile.getInitialFeaturePartOf(fp.getLocation()) instanceof Bridge) {
                    model.onBridge.add(fi);
                } else {
                    model.outsideBridge.add(fi);
                }
                ++order;
            }
        });
        onTile.forEach(t -> {
            Position pos = (Position)t._1;
            NeutralFigure fig = (NeutralFigure)t._2;
            PlacedTile pt = state.getPlacedTile(pos);
            FigureImage fi = new FigureImage(fig);
            fi.offset = this.getFigureOffset(pt, fig, pos);
            this.initFigureImage(fi, pt, fig, pos);
            model.outsideBridge.add(fi);
        });
        return model;
    }

    public Stream<FigureImage> getAllFigureImages() {
        return Stream.concat(this.model.onBridge, this.model.outsideBridge);
    }

    private ImmutablePoint getFigureOffset(PlacedTile placedTile, Figure<?> fig, BoardPointer ptr) {
        ImmutablePoint point = this.getFigureTileOffset(placedTile, fig, ptr);
        Position pos = ptr.getPosition();
        return point.add(100 * pos.x, 100 * pos.y);
    }

    private ImmutablePoint getFigureTileOffset(PlacedTile tile, Figure<?> fig, BoardPointer ptr) {
        if (ptr instanceof Position) {
            if (fig instanceof Fairy) {
                return new ImmutablePoint(62, 52);
            }
            return new ImmutablePoint(50, 50);
        }
        if (fig instanceof Barn) {
            return this.rm.getBarnPlacement();
        }
        FeaturePointer fp = ptr.asFeaturePointer();
        return this.rm.getMeeplePlacement(tile.getTile(), tile.getRotation(), fp.getLocation());
    }

    private void initFigureImage(FigureImage fi, PlacedTile tile, Figure<?> fig, BoardPointer ptr) {
        double baseScale = (double)0.35f * this.gridPanel.getMeepleScaleFactor();
        if (fig instanceof NeutralFigure) {
            Image image;
            boolean mageOrWitch = fig instanceof Mage || fig instanceof Witch;
            boolean count = fig instanceof Count;
            fi.img = image = this.rm.getImage("neutral/" + fig.getClass().getSimpleName().toLowerCase());
            if (mageOrWitch || count) {
                fi.scaleX = 1.2 * baseScale;
                fi.scaleY = 1.2 * baseScale;
            } else if (fig instanceof Fairy) {
                fi.scaleX = baseScale;
                fi.scaleY = baseScale;
            }
        } else {
            Meeple m = (Meeple)fig;
            FeaturePointer fp = ptr.asFeaturePointer();
            Color color = m.getPlayer().getColors().getMeepleColor();
            LayeredImageDescriptor lid = new LayeredImageDescriptor(m.getClass(), color);
            lid.setAdditionalLayer(this.getExtraDecoration(m.getClass(), fp));
            Image image = this.rm.getLayeredImage(lid);
            if (fp.getLocation() == Location.MONASTERY) {
                image = MeepleLayer.rotate(image, 90.0);
            }
            fi.img = image;
            fi.scaleX = baseScale;
            fi.scaleY = baseScale;
        }
    }

    private void paintFigureImages(Graphics2D g, ArrayList<FigureImage> images) {
        int baseSize = this.getTileWidth();
        AffineTransform originalTransform = g.getTransform();
        for (FigureImage fi : images) {
            Image scaled = fi.getScaledInstance(baseSize);
            int width = scaled.getWidth(null);
            int height = scaled.getHeight(null);
            ImmutablePoint scaledOffset = fi.offset.scale(baseSize, this.getTileHeight());
            int x = scaledOffset.getX();
            int y = scaledOffset.getY();
            g.rotate(-this.gridPanel.getBoardRotation().getTheta(), x, y);
            g.drawImage(scaled, x - width / 2, y - height / 2, this.gridPanel);
            g.setTransform(originalTransform);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        this.paintFigureImages(g, this.model.outsideBridge);
    }

    public void paintMeeplesOnBridges(Graphics2D g) {
        this.paintFigureImages(g, this.model.onBridge);
    }

    private String getExtraDecoration(Class<? extends Meeple> type, FeaturePointer fp) {
        if (Follower.class.isAssignableFrom(type) && fp.getLocation().isFarmLocation()) {
            return "player-meeples/decorations/farm";
        }
        if (fp.getLocation() == Location.TOWER) {
            if (BigFollower.class.isAssignableFrom(type)) {
                return "player-meeples/decorations/big_tower";
            }
            return "player-meeples/decorations/tower";
        }
        return null;
    }

    @Deprecated
    public static Image rotate(Image img, double angle) {
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage bimg = new BufferedImage(neww, newh, 2);
        Graphics2D g = bimg.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawRenderedImage(MeepleLayer.toBufferedImage(img), null);
        g.dispose();
        return bimg;
    }

    private static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static class MeppleLayerModel {
        ArrayList<FigureImage> outsideBridge = new ArrayList();
        ArrayList<FigureImage> onBridge = new ArrayList();
    }
}

