/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.grid.layer.TilePlacementLayer;
import com.jcloisterzone.ui.resources.TileImage;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.SortedSet;
import io.vavr.collection.TreeSet;
import java.awt.Graphics2D;
import java.util.Comparator;

public class TileLayer
extends AbstractGridLayer {
    private TilePlacementLayer tilePlacementLayer;
    private SortedSet<Tuple2<Position, PlacedTile>> sortedPlacedTiles = TreeSet.empty();

    public TileLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        if (ev.hasPlacedTilesChanged()) {
            LinkedHashMap<Position, PlacedTile> placedTiles = ev.getCurrentState().getPlacedTiles();
            this.sortedPlacedTiles = placedTiles.toSortedSet(new OrderByRowsComparator());
            this.gridPanel.repaint();
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        if (!this.tilePlacementLayer.isVisible()) {
            g2.setColor(this.getClient().getTheme().getTileBorder());
            int xSize = this.getTileWidth();
            int n = this.getTileHeight();
            int thickness = xSize / 11;
            for (Tuple2 tuple2 : this.sortedPlacedTiles) {
                Position p = (Position)tuple2._1;
                int x = this.getOffsetX(p);
                int y = this.getOffsetY(p);
                g2.fillRect(x - thickness, y - thickness, xSize + 2 * thickness, n + 2 * thickness);
            }
        }
        for (Tuple2 tuple2 : this.sortedPlacedTiles) {
            Position p = (Position)tuple2._1;
            Tile tdef = ((PlacedTile)tuple2._2).getTile();
            Rotation rotation = ((PlacedTile)tuple2._2).getRotation();
            TileImage tileImg = this.rm.getTileImage(tdef.getId(), rotation);
            g2.drawImage(tileImg.getImage(), this.getAffineTransform(tileImg, p), null);
        }
        if (this.tilePlacementLayer.isVisible()) {
            this.tilePlacementLayer.paintBridgePreview(g2);
        }
    }

    public TilePlacementLayer getTilePlacmentLayer() {
        return this.tilePlacementLayer;
    }

    public void setTilePlacmentLayer(TilePlacementLayer tilePlacementLayer) {
        this.tilePlacementLayer = tilePlacementLayer;
    }

    class OrderByRowsComparator
    implements Comparator<Tuple2<Position, PlacedTile>> {
        OrderByRowsComparator() {
        }

        @Override
        public int compare(Tuple2<Position, PlacedTile> o1, Tuple2<Position, PlacedTile> o2) {
            if (o1._1 == null) {
                return o2._1 == null ? 0 : 1;
            }
            return ((Position)o1._1).compareTo((Position)o2._1);
        }
    }
}

