/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.action.TilePlacementAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.TileSymmetry;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.controls.ActionPanel;
import com.jcloisterzone.ui.controls.action.ActionWrapper;
import com.jcloisterzone.ui.controls.action.TilePlacementActionWrapper;
import com.jcloisterzone.ui.grid.ActionLayer;
import com.jcloisterzone.ui.grid.ForwardBackwardListener;
import com.jcloisterzone.ui.grid.GridMouseAdapter;
import com.jcloisterzone.ui.grid.GridMouseListener;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.TileImage;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public class TilePlacementLayer
extends AbstractGridLayer
implements ActionLayer,
GridMouseListener,
ForwardBackwardListener {
    private static final Composite ALLOWED_PREVIEW = AlphaComposite.getInstance(3, 0.8f);
    private static final Composite DISALLOWED_PREVIEW = AlphaComposite.getInstance(3, 0.4f);
    private static final Composite BRIDGE_PREVIEW_FILL_COMPOSITE = AlphaComposite.getInstance(3, 0.75f);
    private boolean rotateWihtMouse = false;
    private boolean active;
    private Set<Position> availablePositions;
    private Position previewPosition;
    private TilePlacementActionWrapper actionWrapper;
    private Set<PlacementOption> allowedRotations;
    private boolean allowedRotation;
    private Rotation realRotation;
    private Rotation previewRotation;
    private FeaturePointer previewBridge;

    public TilePlacementLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Override
    public void setActionWrapper(boolean active, ActionWrapper actionWrapper) {
        this.actionWrapper = (TilePlacementActionWrapper)actionWrapper;
        this.setActive(active);
        if (actionWrapper == null) {
            this.availablePositions = null;
            this.realRotation = null;
        } else {
            this.actionWrapper.setForwardBackwardDelegate(this);
            this.availablePositions = this.getAction().getOptions().map(tp -> tp.getPosition()).distinct();
        }
    }

    @Override
    public TilePlacementActionWrapper getActionWrapper() {
        return this.actionWrapper;
    }

    public TilePlacementAction getAction() {
        return this.getActionWrapper().getAction();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.attachMouseInputListener(new GridMouseAdapter(this.gridPanel, this));
    }

    @Override
    public void onHide() {
        super.onHide();
        this.availablePositions = null;
        this.previewPosition = null;
    }

    private void drawPreviewIcon(Graphics2D g2, Position previewPosition) {
        if (this.realRotation != this.actionWrapper.getTileRotation()) {
            this.preparePreviewRotation(previewPosition);
        }
        TileImage previewIcon = this.rm.getTileImage(this.getAction().getTile().getId(), this.previewRotation);
        Composite compositeBackup = g2.getComposite();
        g2.setComposite(this.allowedRotation ? ALLOWED_PREVIEW : DISALLOWED_PREVIEW);
        g2.drawImage(previewIcon.getImage(), this.getAffineTransform(previewIcon, previewPosition), null);
        g2.setComposite(compositeBackup);
    }

    private void drawRotationHandle(Graphics2D g2, Position previewPosition) {
        Traversable allowed = this.allowedRotations.map(PlacementOption::getRotation);
        List.of(Rotation.values()).filter(arg_0 -> this.lambda$drawRotationHandle$1((Set)allowed, arg_0)).forEach(rotation -> {
            Point2D p = this.getRotationHandlePositions(previewPosition, (Rotation)((Object)rotation));
            g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            if (this.realRotation.add((Rotation)((Object)rotation)).equals((Object)this.previewRotation)) {
                g2.fillOval((int)p.getX() - this.getTileWidth() / 20, (int)p.getY() - this.getTileHeight() / 20, this.getTileWidth() / 9, this.getTileHeight() / 9);
            } else {
                g2.setStroke(new BasicStroke((int)Math.ceil((double)this.getTileWidth() / 75.0)));
                g2.drawOval((int)p.getX() - this.getTileWidth() / 20, (int)p.getY() - this.getTileHeight() / 20, this.getTileWidth() / 9, this.getTileHeight() / 9);
            }
        });
    }

    private Point2D getRotationHandlePositions(Position p, Rotation r) {
        int w = this.getTileWidth();
        int h = this.getTileHeight();
        switch (r) {
            case R0: {
                return new Point(p.x * w + w / 2, p.y * h + h * 5 / 6);
            }
            case R180: {
                return new Point(p.x * w + w / 2, p.y * h + h / 6);
            }
            case R90: {
                return new Point(p.x * w + w / 6, p.y * h + h / 2);
            }
            case R270: {
                return new Point(p.x * w + w * 5 / 6, p.y * h + h / 2);
            }
        }
        throw new NullPointerException("Rotation can't be null");
    }

    private double getSquareDistanceToRotationHandle(Position p, Rotation r, Point2D point) {
        Point2D handle = this.getRotationHandlePositions(p, r);
        return Math.pow(handle.getX() - point.getX(), 2.0) + Math.pow(handle.getY() - point.getY(), 2.0);
    }

    private void preparePreviewRotation(Position p) {
        this.previewRotation = this.realRotation = this.getActionWrapper().getTileRotation();
        this.allowedRotations = this.getAction().getOptions().filter(tp -> tp.getPosition().equals(p));
        PlacementOption matchingPlacement = (PlacementOption)this.allowedRotations.find(tp -> tp.getRotation().equals((Object)this.previewRotation)).getOrNull();
        if (matchingPlacement != null) {
            this.allowedRotation = true;
            this.previewBridge = matchingPlacement.getMandatoryBridge();
        } else {
            TileSymmetry symmetry = this.getAction().getTile().getSymmetry();
            if (this.allowedRotations.size() == 1 || symmetry == TileSymmetry.S2) {
                PlacementOption tp2 = (PlacementOption)this.allowedRotations.get();
                this.allowedRotation = true;
                this.previewRotation = tp2.getRotation();
                this.previewBridge = tp2.getMandatoryBridge();
            } else {
                this.allowedRotation = false;
                this.previewBridge = null;
            }
        }
    }

    @Override
    public void forward() {
        this.rotate(Rotation.R90);
    }

    @Override
    public void backward() {
        this.rotate(Rotation.R270);
    }

    private void rotate(Rotation spin) {
        Set<Rotation> rotations;
        Rotation current = this.getActionWrapper().getTileRotation();
        Rotation next = current.add(spin);
        if (this.getPreviewPosition() != null && !(rotations = this.getAction().getRotations(this.getPreviewPosition())).isEmpty()) {
            if (rotations.size() == 1) {
                next = (Rotation)((Object)rotations.iterator().next());
            } else if (rotations.contains(current)) {
                while (!rotations.contains(next)) {
                    next = next.add(spin);
                }
            } else {
                next = this.getAction().getTile().getSymmetry() == TileSymmetry.S2 && rotations.size() == 2 ? next.add(spin) : current;
                while (!rotations.contains(next)) {
                    next = next.add(spin);
                }
            }
        }
        this.getActionWrapper().setTileRotation(next);
        ActionPanel panel = this.gc.getGameView().getControlPanel().getActionPanel();
        panel.refreshImageCache();
        this.gridPanel.repaint();
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.availablePositions == null) {
            return;
        }
        int xSize = this.getTileWidth() - 4;
        int ySize = this.getTileHeight() - 4;
        int shift = 2;
        int thickness = xSize / 14;
        g2.setColor(this.getClient().getTheme().getTilePlacementColor());
        for (Position p : this.availablePositions) {
            if (this.previewPosition != null && this.previewPosition.equals(p)) continue;
            int x = this.getOffsetX(p) + shift;
            int y = this.getOffsetY(p) + shift;
            g2.fillRect(x, y, xSize, thickness);
            g2.fillRect(x, y + ySize - thickness, xSize, thickness);
            g2.fillRect(x, y, thickness, ySize);
            g2.fillRect(x + xSize - thickness, y, thickness, ySize);
        }
        if (this.previewPosition != null) {
            this.drawPreviewIcon(g2, this.previewPosition);
            if (this.rotateWihtMouse) {
                this.drawRotationHandle(g2, this.previewPosition);
            }
        }
    }

    public void paintBridgePreview(Graphics2D g2) {
        if (this.previewBridge != null) {
            Composite oldComposite = g2.getComposite();
            g2.setColor(Color.WHITE);
            g2.setComposite(BRIDGE_PREVIEW_FILL_COMPOSITE);
            Position bridgePos = this.previewBridge.getPosition();
            Location bridgeLoc = this.previewBridge.getLocation();
            FeatureArea fa = this.rm.getBridgeArea(bridgeLoc).translateTo(bridgePos);
            Area a = fa.getDisplayArea();
            g2.fill(a.createTransformedArea(this.getZoomScale()));
            g2.setComposite(oldComposite);
        }
    }

    @Override
    public void tileEntered(MouseEvent e, Position p) {
        this.rotateWihtMouse = this.getConfig().getTile_rotation() == Config.TileRotationControls.TAB_RCLICK_MOUSEMOVE;
        this.realRotation = null;
        if (this.availablePositions.contains(p)) {
            this.previewPosition = p;
            this.gridPanel.repaint();
        }
    }

    @Override
    public void tileExited(MouseEvent e, Position p) {
        this.realRotation = null;
        if (this.previewPosition != null) {
            this.previewPosition = null;
            this.previewBridge = null;
            this.gridPanel.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e, Position p) {
        if (e.getButton() == 1 && this.getPreviewPosition() != null && this.isActive() && this.allowedRotation) {
            e.consume();
            if (!this.gc.getActionLock().get()) {
                this.gc.getConnection().send(this.getAction().select(new PlacementOption(p, this.previewRotation, null)));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e, Position p) {
        if (this.rotateWihtMouse && this.realRotation != null) {
            Point2D point = this.gridPanel.getRelativePoint(e.getPoint());
            Tuple2 closest = (Tuple2)List.of(Rotation.values()).map(r -> new Tuple2<Rotation, Double>((Rotation)((Object)r), this.getSquareDistanceToRotationHandle(p, (Rotation)((Object)r), point))).minBy(Tuple2::_2).getOrNull();
            if (closest != null) {
                PlacementOption matchingPlacement;
                Rotation combinedRot;
                Rotation rot = (Rotation)((Object)closest._1);
                double distance = (Double)closest._2;
                if (distance <= (double)(this.getTileWidth() * this.getTileHeight() / 40) && this.previewRotation != (combinedRot = this.realRotation.add(rot)) && (matchingPlacement = (PlacementOption)this.allowedRotations.filter(opt -> opt.getRotation() == combinedRot).getOrNull()) != null) {
                    this.previewRotation = combinedRot;
                    this.previewBridge = matchingPlacement.getMandatoryBridge();
                    this.allowedRotation = true;
                    this.gridPanel.repaint();
                }
            }
        }
    }

    public Position getPreviewPosition() {
        return this.previewPosition;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private /* synthetic */ boolean lambda$drawRotationHandle$1(Set allowed, Rotation r) {
        return allowed.contains(this.realRotation.add(r));
    }
}

