/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.game.state.PlacedTunnelToken;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;

public class TokenLayer
extends AbstractGridLayer {
    private TokenLayerModel model = new TokenLayerModel();

    public TokenLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        Map prevLbModel;
        Map currLbModel;
        Map prevTunnelModel;
        Map currTunnelModel = (Map)ev.getCurrentState().getCapabilityModel(TunnelCapability.class);
        if (currTunnelModel != null && (prevTunnelModel = (Map)ev.getPrevState().getCapabilityModel(TunnelCapability.class)) != currTunnelModel) {
            this.model.tunnels = this.createTunnelsViewModel(ev.getCurrentState(), currTunnelModel);
        }
        if ((currLbModel = (Map)ev.getCurrentState().getCapabilityModel(LittleBuildingsCapability.class)) != null && (prevLbModel = (Map)ev.getPrevState().getCapabilityModel(LittleBuildingsCapability.class)) != currLbModel) {
            this.model.buildings = this.createLbViewModel(ev.getCurrentState(), currLbModel);
        }
    }

    private Seq<Tuple2<ImmutablePoint, Image>> createLbViewModel(GameState state, Map<Position, LittleBuildingsCapability.LittleBuilding> lbState) {
        ImmutablePoint point = new ImmutablePoint(65, 35);
        return lbState.map(t -> {
            Position pos = (Position)t._1;
            Token lb = (Token)t._2;
            String imgName = lb.name().toLowerCase();
            Image img = this.rm.getImage("neutral/" + imgName);
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            if (lb == LittleBuildingsCapability.LittleBuilding.LB_TOWER) {
                img = img.getScaledInstance(w, (int)((double)h * 0.7), 4);
            }
            return new Tuple2<ImmutablePoint, Image>(point.translate(pos.x * 100, pos.y * 100), img);
        });
    }

    private Seq<Tuple2<ImmutablePoint, Image>> createTunnelsViewModel(GameState state, Map<FeaturePointer, PlacedTunnelToken> tunnelsState) {
        return tunnelsState.filterValues(Predicates.isNotNull()).map(t -> {
            FeaturePointer fp = (FeaturePointer)t._1;
            Position pos = fp.getPosition();
            PlacedTunnelToken placedTunnel = (PlacedTunnelToken)t._2;
            Player player = state.getPlayers().getPlayer(placedTunnel.getPlayerIndex());
            Color color = player.getSlot().getColors().getTunnelColors().get(((PlacedTunnelToken)t._2).getToken());
            Image img = this.rm.getLayeredImage(new LayeredImageDescriptor("player-meeples/tunnel", color));
            PlacedTile pt = state.getPlacedTiles().get(pos).get();
            ImmutablePoint point = this.rm.getMeeplePlacement(pt.getTile(), pt.getRotation(), fp.getLocation());
            point = new ImmutablePoint((int)((double)point.getX() / 2.0 + 25.0), (int)((double)point.getY() / 2.0 + 25.0));
            return new Tuple2<ImmutablePoint, Image>(point.translate(pos.x * 100, pos.y * 100), img);
        });
    }

    @Override
    public void paint(Graphics2D g2) {
        AffineTransform originalTransform = g2.getTransform();
        int baseSize = this.getTileWidth();
        AffineTransform scaleTx = this.getPointZoomScale();
        for (Tuple2 tunnel : Stream.concat(this.model.tunnels, this.model.buildings)) {
            ImmutablePoint scaledOffset = ((ImmutablePoint)tunnel._1).transform(scaleTx);
            Image scaled = ((Image)tunnel._2).getScaledInstance((int)((double)baseSize / 2.1), (int)((double)baseSize / 2.1), 4);
            ImageIcon ico = new ImageIcon(scaled);
            int width = ico.getIconWidth();
            int height = ico.getIconHeight();
            int x = scaledOffset.getX();
            int y = scaledOffset.getY();
            g2.rotate(-this.gridPanel.getBoardRotation().getTheta(), x, y);
            g2.drawImage(ico.getImage(), x - width / 2, y - height / 2, this.gridPanel);
            g2.setTransform(originalTransform);
        }
    }

    public static class TokenLayerModel {
        Seq<Tuple2<ImmutablePoint, Image>> tunnels = List.empty();
        Seq<Tuple2<ImmutablePoint, Image>> buildings = List.empty();
    }
}

