/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;

public class TowerLayer
extends AbstractGridLayer {
    private static final Color FILL_COLOR = new Color(40, 40, 40, 150);
    private TowerLayerModel model = new TowerLayerModel();

    public TowerLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        boolean towersChanged = false;
        for (PlayEvent pe : ev.getPlayEventsSymmetricDifference()) {
            TokenPlacedEvent tpe;
            if (!(pe instanceof TokenPlacedEvent) || (tpe = (TokenPlacedEvent)pe).getToken() != TowerCapability.TowerToken.TOWER_PIECE) continue;
            towersChanged = true;
            break;
        }
        if (towersChanged) {
            this.model = this.createModel(ev.getCurrentState());
        }
    }

    private TowerLayerModel createModel(GameState state) {
        TowerLayerModel model = new TowerLayerModel();
        model.towers = Stream.ofAll(state.getFeatureMap()).filter(t -> t._2 instanceof Tower && ((Tower)t._2).getHeight() > 0).distinctBy(t -> (Feature)t._2).map(t -> {
            Position pos = ((FeaturePointer)t._1).getPosition();
            PlacedTile pt = state.getPlacedTile(pos);
            return new Tuple2<PlacedTile, Tower>(pt, (Tower)t._2);
        }).toList();
        return model;
    }

    @Override
    public void paint(Graphics2D g2) {
        g2.setColor(FILL_COLOR);
        for (Tuple2 tuple2 : this.model.towers) {
            PlacedTile pt = (PlacedTile)tuple2._1;
            Tower tower = (Tower)tuple2._2;
            Area ra = this.rm.getFeatureArea(pt.getTile(), pt.getRotation(), Location.TOWER).translateTo(pt.getPosition()).getDisplayArea().createTransformedArea(this.getZoomScale());
            g2.fill(ra);
            this.drawAntialiasedTextCenteredNoScale(g2, "" + tower.getHeight(), 22, Position.ZERO, new ImmutablePoint((int)ra.getBounds2D().getCenterX(), (int)ra.getBounds2D().getCenterY()), Color.WHITE, null);
        }
    }

    public static class TowerLayerModel {
        List<Tuple2<PlacedTile, Tower>> towers = List.empty();
    }
}

