/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.config.Config;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.view.StartView;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectGamePanel
extends ThemedJPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;
    private JTextField hostField;
    private JTextField portField;
    private JButton btnConnect;
    private JButton btnBack;
    private JLabel message;

    public ConnectGamePanel(Client client) {
        this.client = client;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectGamePanel.this.btnConnect.setEnabled(false);
                ConnectGamePanel.this.message.setForeground(Color.BLACK);
                ConnectGamePanel.this.message.setText(I18nUtils._tr("Connecting", new Object[0]) + "...");
                String port = ConnectGamePanel.this.portField.getText().trim();
                if (port.equals("")) {
                    ConnectGamePanel.this.portField.setText(ConnectGamePanel.this.client.getConfig().getPort() + "");
                }
                ConnectGamePanel.this.saveHistory();
                ConnectGamePanel.this.connect();
            }
        };
        if (!client.getTheme().isDark()) {
            this.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        }
        this.setLayout(new MigLayout("", "[80.00][][grow]", "[][][][][]"));
        ThemedJLabel helpLabel = new ThemedJLabel("Enter remote host address.");
        this.add((Component)helpLabel, "cell 0 0,spanx 3");
        ThemedJLabel hostLabel = new ThemedJLabel(I18nUtils._tr("Host", new Object[0]));
        this.add((Component)hostLabel, "cell 0 1,alignx left,aligny top, gaptop 10");
        String[] hostPost = this.getDefaultHostPort();
        this.hostField = new JTextField();
        this.hostField.addActionListener(actionListener);
        this.add((Component)this.hostField, "cell 1 1,spanx 2,growx, width 250::");
        this.hostField.setColumns(10);
        this.hostField.setText(hostPost[0]);
        ThemedJLabel portLabel = new ThemedJLabel(I18nUtils._tr("Port", new Object[0]));
        this.add((Component)portLabel, "cell 0 2,alignx left, gaptop 5");
        this.portField = new JTextField();
        this.portField.addActionListener(actionListener);
        this.add((Component)this.portField, "cell 1 2,spanx 2,growx, width 250::");
        this.portField.setColumns(10);
        this.portField.setText(hostPost[1]);
        this.btnConnect = new JButton(I18nUtils._tr("Connect", new Object[0]));
        this.btnConnect.addActionListener(actionListener);
        this.add((Component)this.btnConnect, "cell 1 3");
        this.btnBack = new JButton(I18nUtils._tr("Back", new Object[0]));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectGamePanel.this.client.mountView(new StartView(ConnectGamePanel.this.client));
            }
        });
        this.add((Component)this.btnBack, "cell 2 3");
        this.message = new ThemedJLabel("");
        this.message.setForeground(Color.BLACK);
        this.add((Component)this.message, "cell 1 4, spanx 2, height 20");
    }

    private String[] getDefaultHostPort() {
        int port = this.client.getConfig().getPort() == null ? 37447 : this.client.getConfig().getPort();
        List<String> history = this.client.getConfig().getConnection_history();
        if (history == null || history.isEmpty()) {
            return new String[]{"", port + ""};
        }
        String[] hp = history.get(0).split(":");
        if (hp.length > 1) {
            return hp;
        }
        return new String[]{hp[0], port + ""};
    }

    private void saveHistory() {
        Config cfg = this.client.getConfig();
        String record = this.hostField.getText().trim();
        String port = this.portField.getText().trim();
        if (!port.equals(this.client.getConfig().getPort() + "")) {
            record = record + ":" + port;
        }
        cfg.setConnection_history(Collections.singletonList(record));
        this.client.saveConfig();
    }

    public void onWebsocketError(Exception ex) {
        this.message.setForeground(Color.RED);
        this.btnConnect.setEnabled(true);
        if (ex instanceof UnresolvedAddressException) {
            this.message.setText(I18nUtils._tr("Connection failed. Unknown host.", new Object[0]));
        } else if (ex instanceof ConnectException && ex.getMessage().contains("Connection refused")) {
            this.message.setText(I18nUtils._tr("Connection refused.", new Object[0]));
        } else {
            this.message.setText(I18nUtils._tr("Connection failed.", new Object[0]) + " (" + ex.getMessage() + ")");
            this.logger.info(ex.getMessage(), ex);
        }
    }

    private void connect() {
        try {
            String hostname = this.hostField.getText().trim();
            String portStr = this.portField.getText().trim();
            int port = Integer.parseInt(portStr);
            this.client.connect(hostname, port);
            return;
        }
        catch (NumberFormatException nfe) {
            this.message.setText(I18nUtils._tr("Invalid port number.", new Object[0]));
            this.message.setForeground(Color.RED);
            this.btnConnect.setEnabled(true);
            return;
        }
    }
}

