/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.wsio.message.ClientUpdateMessage;
import com.jcloisterzone.wsio.server.RemoteClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedClientsPanel
extends JPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Font FONT_TITLE = new Font(null, 1, 20);
    private JTextPane connectedClients;

    public ConnectedClientsPanel(Client client, String titleText) {
        Color bg = client.getTheme().getPanelBg();
        if (bg == null) {
            bg = Color.WHITE;
        }
        this.setLayout(new MigLayout("ins 0, fillx", "[grow]", "[][grow]"));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBackground(bg);
        JLabel title = new JLabel(titleText);
        title.setFont(FONT_TITLE);
        this.add((Component)title, "wrap");
        this.connectedClients = new JTextPane();
        this.connectedClients.setToolTipText(I18nUtils._tr("Connected clients", new Object[0]));
        this.connectedClients.setEditable(false);
        this.connectedClients.setBackground(bg);
        this.connectedClients.setForeground(client.getTheme().getTextColor());
        this.add((Component)this.connectedClients, "wrap, grow, align 0 0");
    }

    public void updateClients(List<RemoteClient> clients) {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        ArrayList<RemoteClient> inGameClients = new ArrayList<RemoteClient>();
        int offs = 0;
        try {
            String text;
            SimpleAttributeSet attrs;
            for (RemoteClient rc : clients) {
                if (ClientUpdateMessage.ClientState.ACTIVE.equals((Object)rc.getState())) {
                    attrs = new SimpleAttributeSet();
                    text = rc.getName();
                    doc.insertString(offs, text + "\n", attrs);
                    offs += text.length() + 1;
                }
                if (!ClientUpdateMessage.ClientState.IN_GAME.equals((Object)rc.getState())) continue;
                inGameClients.add(rc);
            }
            if (!inGameClients.isEmpty()) {
                doc.insertString(offs, "\n", new SimpleAttributeSet());
                ++offs;
                for (RemoteClient rc : inGameClients) {
                    attrs = new SimpleAttributeSet();
                    StyleConstants.ColorConstants.setForeground(attrs, Color.LIGHT_GRAY);
                    text = rc.getName();
                    doc.insertString(offs, text + "\n", attrs);
                    offs += text.length() + 1;
                }
            }
        }
        catch (BadLocationException e) {
            this.logger.error(e.getMessage(), e);
        }
        this.connectedClients.setDocument(doc);
        this.connectedClients.repaint();
    }
}

