/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.ExpansionType;
import com.jcloisterzone.board.TilePackBuilder;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.event.setup.ExpansionChangedEvent;
import com.jcloisterzone.event.setup.PlayerSlotChangeEvent;
import com.jcloisterzone.event.setup.RuleChangeEvent;
import com.jcloisterzone.event.setup.SupportedExpansionsChangeEvent;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.component.TextPrompt;
import com.jcloisterzone.ui.gtk.ThemedJCheckBox;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.panel.CreateGamePlayerPanel;
import com.jcloisterzone.ui.panel.NameProvider;
import com.jcloisterzone.wsio.message.SetCapabilityMessage;
import com.jcloisterzone.wsio.message.SetExpansionMessage;
import com.jcloisterzone.wsio.message.SetRuleMessage;
import com.jcloisterzone.wsio.message.StartGameMessage;
import io.vavr.collection.Set;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGamePanel
extends ThemedJPanel
implements UIEventListener {
    private static final long serialVersionUID = -8993000662700228625L;
    static Font FONT_RULE_SECTION = new Font(null, 2, 13);
    static Font FONT_PLUGIN_EXPANSION = new Font(null, 2, 13);
    private final Client client;
    private final Game game;
    private final GameController gc;
    private boolean mutableSlots;
    private JPanel playersPanel;
    private JComboBox<Object> presets;
    private JButton presetSave;
    private JButton presetDelete;
    private JButton leaveGameButton;
    private JButton startGameButton;
    private JPanel expansionPanel;
    private JPanel rulesPanel;
    private JPanel header;
    private JCheckBox timeLimitChbox;
    private JSpinner timeLimitSpinner;
    private SpinnerNumberModel timeLimitModel;
    private Map<Expansion, JComponent[]> expansionComponents = new HashMap<Expansion, JComponent[]>();
    private Map<Rule, JCheckBox> ruleCheckboxes = new HashMap<Rule, JCheckBox>();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public CreateGamePanel(Client client, final GameController gc, boolean mutableSlots, PlayerSlot[] slots) {
        this.client = client;
        this.gc = gc;
        this.game = gc.getGame();
        this.mutableSlots = mutableSlots;
        NameProvider nameProvider = new NameProvider(client.getConfig());
        this.setLayout(new MigLayout("", "[grow]", "[][grow]"));
        this.header = new ThemedJPanel();
        this.add((Component)this.header, "cell 0 0, growx");
        this.header.setBackground(client.getTheme().getMainBg());
        this.header.setLayout(new MigLayout("", "[grow]"));
        this.startGameButton = new JButton(I18nUtils._tr("Start game", new Object[0]));
        this.startGameButton.setFont(new Font(null, 0, 25));
        this.header.add((Component)this.startGameButton, "width 240, h 40, east");
        if (gc.getChannel() != null) {
            this.leaveGameButton = new JButton(I18nUtils._tr("Leave game", new Object[0]));
            this.header.add((Component)this.leaveGameButton, "h pref!, gapx 10px 10px, east");
            this.leaveGameButton.addActionListener(new ActionListener(){
                final /* synthetic */ CreateGamePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    gc.leaveGame();
                }
            });
        }
        this.startGameButton.addActionListener(new ActionListener(){
            final /* synthetic */ CreateGamePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GameSetup originalSetup;
                java.util.Set<Expansion> supported = this.this$0.game.mergeSupportedExpansions();
                GameSetup setup = originalSetup = this.this$0.game.getSetup();
                for (Expansion exp : setup.getExpansions().keySet()) {
                    if (supported.contains(exp)) continue;
                    setup = setup.mapExpansions(m -> m.remove(exp));
                    gc.getConnection().send(new SetExpansionMessage(exp, 0));
                }
                this.this$0.sendCapabilityChange(originalSetup, setup);
                StartGameMessage msg = new StartGameMessage();
                gc.getConnection().send(msg);
            }
        });
        if (mutableSlots) {
            this.header.add((Component)this.createPresetPanel(), "west");
        }
        ThemedJPanel scrolled = new ThemedJPanel();
        scrolled.setBackground(client.getTheme().getMainBg());
        scrolled.setLayout(new MigLayout("", "[][grow][grow]", "[grow]"));
        this.playersPanel = new ThemedJPanel();
        if (!client.getTheme().isDark()) {
            this.playersPanel.setBorder(new TitledBorder(null, I18nUtils._tr("Players", new Object[0]), 4, 2, null, null));
        }
        this.playersPanel.setLayout(new MigLayout("", "[grow]", ""));
        if (mutableSlots) {
            ThemedJLabel hint = new ThemedJLabel(I18nUtils._tr("Click twice on a slot button to add a computer player.", new Object[0]));
            hint.setFont(new Font(null, 2, 11));
            hint.setForeground(client.getTheme().getHintColor());
            this.playersPanel.add((Component)hint, "aligny bottom, gapbottom 5, wrap");
        }
        for (PlayerSlot slot : slots) {
            if (slot == null) continue;
            CreateGamePlayerPanel panel = new CreateGamePlayerPanel(client, gc, mutableSlots, slot, slots);
            panel.setNameProvider(nameProvider);
            this.playersPanel.add((Component)panel, "wrap");
        }
        if (mutableSlots) {
            JCheckBox randomSeating = this.createRuleCheckbox(Rule.RANDOM_SEATING_ORDER, true);
            this.playersPanel.add((Component)randomSeating, "wrap, gaptop 10");
            this.ruleCheckboxes.put(Rule.RANDOM_SEATING_ORDER, randomSeating);
        }
        this.playersPanel.add((Component)this.createClockPanel(), "wrap, gaptop 10, grow");
        scrolled.add((Component)this.playersPanel, "cell 0 0, grow");
        this.expansionPanel = new ThemedJPanel();
        if (!client.getTheme().isDark()) {
            this.expansionPanel.setBorder(new TitledBorder(null, I18nUtils._tr("Expansions", new Object[0]), 4, 2, null, null));
        }
        TilePackBuilder tilePackBuilder = new TilePackBuilder();
        tilePackBuilder.setConfig(client.getConfig());
        this.expansionPanel.setLayout(new MigLayout("gapy 1", "[][right]", "[]"));
        for (ExpansionType expType : ExpansionType.values()) {
            boolean showGap = expType != ExpansionType.BASIC;
            for (Expansion exp2 : Expansion.values().filter(exp -> exp.getType() == expType)) {
                this.createExpansionLine(exp2, tilePackBuilder.getExpansionSize(exp2), showGap);
                showGap = false;
            }
        }
        scrolled.add((Component)this.expansionPanel, "cell 1 0,grow");
        this.rulesPanel = new ThemedJPanel();
        if (!client.getTheme().isDark()) {
            this.rulesPanel.setBorder(new TitledBorder(null, I18nUtils._tr("Rules", new Object[0]), 4, 2, null, null));
        }
        this.rulesPanel.setLayout(new MigLayout("", "[]", "[]"));
        scrolled.add((Component)this.rulesPanel, "cell 2 0,grow");
        boolean legacySection = false;
        Expansion prev = Expansion.BASIC;
        for (Rule rule : Rule.values()) {
            if (rule.getExpansion() == null) continue;
            if (prev != rule.getExpansion() && !legacySection) {
                prev = rule.getExpansion();
                ThemedJLabel label = new ThemedJLabel(rule == Rule.TINY_CITY_2_POINTS ? I18nUtils._tr("Legacy Rules", new Object[0]) : prev.toString());
                label.setFont(FONT_RULE_SECTION);
                this.rulesPanel.add((Component)label, "wrap, growx, gaptop 10, gapbottom 7");
            }
            JCheckBox chbox = this.createRuleCheckbox(rule, mutableSlots);
            this.rulesPanel.add((Component)chbox, "wrap");
            this.ruleCheckboxes.put(rule, chbox);
            if (rule != Rule.TINY_CITY_2_POINTS) continue;
            legacySection = true;
        }
        JScrollPane scroll = new JScrollPane(scrolled);
        scroll.setViewportBorder(null);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scroll, "cell 0 1, grow");
        this.onSlotStateChange();
        this.startGameButton.requestFocus();
    }

    private JPanel createClockPanel() {
        ThemedJPanel clockPanel = new ThemedJPanel();
        if (!this.client.getTheme().isDark()) {
            clockPanel.setBorder(new TitledBorder(null, I18nUtils._tr("Clock", new Object[0]), 4, 2, null, null));
        }
        clockPanel.setLayout(new MigLayout("", "[][][]", ""));
        Integer value = (Integer)this.game.getSetup().getRules().get(Rule.CLOCK_PLAYER_TIME).getOrNull();
        this.timeLimitChbox = new ThemedJCheckBox(I18nUtils._tr("player time limit", new Object[0]), value != null);
        this.timeLimitChbox.setEnabled(this.mutableSlots);
        this.timeLimitSpinner = new JSpinner();
        this.timeLimitModel = new SpinnerNumberModel(value == null ? 20 : value / 60, 0, 300, 1);
        this.timeLimitSpinner.setModel(this.timeLimitModel);
        this.timeLimitSpinner.setEnabled(this.mutableSlots);
        if (value == null) {
            this.timeLimitSpinner.setEnabled(false);
        }
        clockPanel.add(this.timeLimitChbox);
        clockPanel.add((Component)this.timeLimitSpinner, "w 40");
        clockPanel.add((Component)new ThemedJLabel(I18nUtils._tr("minutes", new Object[0])), "gapleft 4");
        if (this.mutableSlots) {
            this.timeLimitChbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetRuleMessage msg;
                    boolean selected = CreateGamePanel.this.timeLimitChbox.isSelected();
                    if (selected) {
                        int value = 60 * CreateGamePanel.this.timeLimitModel.getNumber().intValue();
                        msg = new SetRuleMessage(Rule.CLOCK_PLAYER_TIME, value);
                    } else {
                        msg = new SetRuleMessage(Rule.CLOCK_PLAYER_TIME, null);
                    }
                    CreateGamePanel.this.gc.getConnection().send(msg);
                }
            });
            this.timeLimitSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Integer value;
                    if (CreateGamePanel.this.timeLimitChbox.isSelected() && (value = Integer.valueOf(CreateGamePanel.this.timeLimitModel.getNumber().intValue() * 60)) != CreateGamePanel.this.game.getSetup().getRules().get(Rule.CLOCK_PLAYER_TIME).getOrNull()) {
                        SetRuleMessage msg = new SetRuleMessage(Rule.CLOCK_PLAYER_TIME, value);
                        CreateGamePanel.this.gc.getConnection().send(msg);
                    }
                }
            });
        }
        return clockPanel;
    }

    private JPanel createPresetPanel() {
        ThemedJPanel presetPanel = new ThemedJPanel();
        if (!this.client.getTheme().isDark()) {
            presetPanel.setBorder(new TitledBorder(null, I18nUtils._tr("Presets", new Object[0]), 4, 2, null, null));
        }
        presetPanel.setLayout(new MigLayout());
        this.presets = new JComboBox<Preset>(this.getPresets());
        this.presets.setEditable(true);
        this.presets.setSelectedItem("");
        this.presets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGamePanel.this.presets.getSelectedItem() instanceof Preset) {
                    Preset profile = (Preset)CreateGamePanel.this.presets.getSelectedItem();
                    profile.getConfig().updateGameSetup(CreateGamePanel.this.gc.getConnection(), CreateGamePanel.this.game.getGameId());
                }
            }
        });
        presetPanel.add(this.presets, "width 160, gapright 10, west");
        JTextComponent editorComponent = (JTextComponent)this.presets.getEditor().getEditorComponent();
        TextPrompt tp = new TextPrompt(I18nUtils._tr("Preset name", new Object[0]), editorComponent);
        tp.setShow(TextPrompt.Show.FOCUS_LOST);
        tp.changeStyle(2);
        tp.changeAlpha(0.4f);
        editorComponent.getDocument().addDocumentListener(new DocumentListener(){

            private void handle(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    CreateGamePanel.this.updatePresetButtons(doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException ex) {
                    CreateGamePanel.this.logger.error(ex.getMessage(), ex);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handle(e);
            }
        });
        this.presetSave = new JButton(I18nUtils._tr("Save", new Object[0]));
        this.presetSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preset profile;
                Object item = CreateGamePanel.this.presets.getSelectedItem();
                if (item instanceof String && (profile = CreateGamePanel.this.getPresetFor((String)item)) != null) {
                    item = profile;
                }
                profile = null;
                if (item instanceof String) {
                    profile = new Preset(((String)item).trim(), CreateGamePanel.this.createCurrentConfig());
                    CreateGamePanel.this.presets.addItem(profile);
                } else {
                    profile = (Preset)item;
                    profile.setConfig(CreateGamePanel.this.createCurrentConfig());
                }
                Config config = CreateGamePanel.this.client.getConfig();
                config.getPresets().put(profile.getName(), profile.getConfig());
                CreateGamePanel.this.client.saveConfig();
                CreateGamePanel.this.updatePresetButtons(CreateGamePanel.this.presets.getSelectedItem());
            }
        });
        presetPanel.add((Component)this.presetSave, "width 80, gapright 10, west");
        this.presetDelete = new JButton(I18nUtils._tr("Delete", new Object[0]));
        this.presetDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = CreateGamePanel.this.presets.getSelectedItem();
                if (item instanceof String) {
                    item = CreateGamePanel.this.getPresetFor((String)item);
                }
                if (item instanceof Preset) {
                    Preset preset = (Preset)item;
                    CreateGamePanel.this.presets.removeItem(preset);
                    Config config = CreateGamePanel.this.client.getConfig();
                    config.getPresets().remove(preset.getName());
                    CreateGamePanel.this.client.saveConfig();
                    CreateGamePanel.this.presets.setSelectedItem("");
                    CreateGamePanel.this.updatePresetButtons("");
                }
            }
        });
        presetPanel.add((Component)this.presetDelete, "width 80, west");
        this.updatePresetButtons(this.presets.getSelectedItem());
        return presetPanel;
    }

    private void updatePresetButtons(Object item) {
        Preset preset;
        if (item instanceof String && (preset = this.getPresetFor((String)(item = ((String)item).trim()))) != null) {
            item = preset;
        }
        if (item instanceof Preset) {
            this.presetSave.setEnabled(true);
            this.presetDelete.setEnabled(true);
        } else {
            this.presetDelete.setEnabled(false);
            if ("".equals(item)) {
                this.presetSave.setEnabled(false);
            } else {
                this.presetSave.setEnabled(true);
            }
        }
    }

    private void createExpansionLine(Expansion exp, int expSize, boolean showGap) {
        JCheckBox chbox = this.createExpansionCheckbox(exp, this.mutableSlots);
        if (showGap) {
            this.expansionPanel.add((Component)chbox, "gaptop 5");
        } else {
            this.expansionPanel.add((Component)chbox, "");
        }
        ThemedJLabel expansionSize = new ThemedJLabel(expSize + "");
        expansionSize.setForeground(Color.GRAY);
        this.expansionPanel.add((Component)expansionSize, "wrap");
        this.expansionComponents.put(exp, new JComponent[]{chbox, expansionSize});
    }

    private Preset getPresetFor(String name) {
        if ("".equals(name = name.trim())) {
            return null;
        }
        int count = this.presets.getItemCount();
        for (int i = 0; i < count; ++i) {
            Preset profile = (Preset)this.presets.getItemAt(i);
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    private Config.PresetConfig createCurrentConfig() {
        GameSetup setup = this.game.getSetup();
        Map<String, Integer> expansions = setup.getExpansions().mapKeys(exp -> exp.name()).toJavaMap();
        List<String> capabilities = setup.getCapabilities().map(cap -> Capability.nameForClass(cap)).toJavaList();
        Config.PresetConfig config = new Config.PresetConfig();
        config.setExpansions(expansions);
        config.setRules(setup.getRules().toJavaMap());
        config.setCapabilities(capabilities);
        return config;
    }

    private Preset[] getPresets() {
        Map<String, Config.PresetConfig> presetCfg = this.client.getConfig().getPresets();
        if (presetCfg == null) {
            return new Preset[0];
        }
        ArrayList<Preset> profiles = new ArrayList<Preset>();
        for (Map.Entry<String, Config.PresetConfig> e : presetCfg.entrySet()) {
            profiles.add(new Preset(e.getKey(), e.getValue()));
        }
        Collections.sort(profiles);
        return profiles.toArray(new Preset[profiles.size()]);
    }

    public void disposePanel() {
        for (Component comp : this.playersPanel.getComponents()) {
            if (!(comp instanceof CreateGamePlayerPanel)) continue;
            ((CreateGamePlayerPanel)comp).disposePanel();
        }
    }

    private JCheckBox createRuleCheckbox(final Rule rule, boolean mutableSlots) {
        ThemedJCheckBox chbox = new ThemedJCheckBox(rule.getLabel(), this.game.getSetup().getBooleanValue(rule));
        if (mutableSlots) {
            chbox.addActionListener(new ActionListener(){
                final /* synthetic */ CreateGamePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox chbox = (JCheckBox)e.getSource();
                    GameSetup setup = this.this$0.game.getSetup();
                    setup = chbox.isSelected() ? setup.mapRules(m -> m.put(rule, Boolean.TRUE)) : setup.mapRules(m -> m.remove(rule));
                    SetRuleMessage msg = new SetRuleMessage(rule, chbox.isSelected());
                    this.this$0.gc.getConnection().send(msg);
                    this.this$0.sendCapabilityChange(this.this$0.game.getSetup(), setup);
                }
            });
        } else {
            chbox.setEnabled(false);
        }
        return chbox;
    }

    private void sendCapabilityChange(GameSetup s1, GameSetup s2) {
        SetCapabilityMessage msg;
        Set<Class<Capability<?>>> oldCap = GameSetup.getCapabilitiesForExpansionsAndRules(s1.getExpansions(), s1.getRules());
        Set<Class<Capability<?>>> newCap = GameSetup.getCapabilitiesForExpansionsAndRules(s2.getExpansions(), s2.getRules());
        for (Class clazz : oldCap.diff(newCap)) {
            msg = new SetCapabilityMessage(clazz, false);
            this.gc.getConnection().send(msg);
        }
        for (Class clazz : newCap.diff(oldCap)) {
            msg = new SetCapabilityMessage(clazz, true);
            this.gc.getConnection().send(msg);
        }
    }

    private JCheckBox createExpansionCheckbox(final Expansion exp, boolean mutableSlots) {
        ThemedJCheckBox chbox = new ThemedJCheckBox(exp.toString(), this.game.getSetup().hasExpansion(exp));
        if (!mutableSlots) {
            chbox.setEnabled(false);
        }
        if (exp == Expansion.BASIC) {
            boolean hasMultipleBasics;
            boolean bl = hasMultipleBasics = Expansion.values().filter(e -> e.getType() == ExpansionType.BASIC).size() > 1;
            if (!hasMultipleBasics) {
                chbox.setEnabled(false);
            }
        }
        if (exp.getOrigin() != null) {
            chbox.setFont(FONT_PLUGIN_EXPANSION);
        }
        if (chbox.isEnabled()) {
            chbox.addActionListener(new ActionListener(){
                final /* synthetic */ CreateGamePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox chbox = (JCheckBox)e.getSource();
                    GameSetup setup = this.this$0.game.getSetup();
                    setup = chbox.isSelected() ? setup.mapExpansions(m -> m.put(exp, 1)) : setup.mapExpansions(m -> m.remove(exp));
                    SetExpansionMessage msg = new SetExpansionMessage(exp, chbox.isSelected() ? 1 : 0);
                    this.this$0.gc.getConnection().send(msg);
                    this.this$0.sendCapabilityChange(this.this$0.game.getSetup(), setup);
                }
            });
        }
        return chbox;
    }

    public void updateRule(Rule rule, Object value) {
        if (rule.getType().equals(Boolean.class)) {
            boolean enabled;
            JCheckBox chbox = this.ruleCheckboxes.get((Object)rule);
            boolean bl = enabled = value == null ? false : (Boolean)value;
            if (chbox != null && chbox.isSelected() != enabled) {
                chbox.setSelected(enabled);
                UiUtils.highlightComponent(chbox);
            }
            if (rule == Rule.RANDOM_SEATING_ORDER) {
                this.updateSerialLabels();
            }
        } else if (rule == Rule.CLOCK_PLAYER_TIME) {
            if (value == null) {
                this.timeLimitChbox.setSelected(false);
                this.timeLimitSpinner.setEnabled(false);
            } else {
                this.timeLimitChbox.setSelected(true);
                this.timeLimitSpinner.setEnabled(true);
                this.timeLimitModel.setValue((Integer)value / 60);
            }
        }
    }

    public void updateExpansion(Expansion expansion, int count) {
        JCheckBox chbox = (JCheckBox)this.expansionComponents.get(expansion)[0];
        if (chbox.isSelected() != count > 0) {
            chbox.setSelected(count > 0);
            UiUtils.highlightComponent(chbox);
        }
    }

    public void updateSupportedExpansions(java.util.Set<Expansion> expansions) {
        for (Expansion exp : Expansion.values()) {
            JComponent[] components;
            boolean isSupported = expansions == null || expansions.contains(exp);
            for (JComponent comp : components = this.expansionComponents.get(exp)) {
                comp.setVisible(isSupported);
            }
        }
    }

    private CreateGamePlayerPanel getPlayerPanel(int number) {
        for (Component comp : this.playersPanel.getComponents()) {
            CreateGamePlayerPanel panel;
            PlayerSlot slot;
            if (!(comp instanceof CreateGamePlayerPanel) || (slot = (panel = (CreateGamePlayerPanel)comp).getSlot()) == null || slot.getNumber() != number) continue;
            return panel;
        }
        throw new IllegalArgumentException("Slot " + number + " does not exit.");
    }

    public void updateSlot(int number) {
        this.getPlayerPanel(number).updateSlot();
        this.onSlotStateChange();
    }

    private void updateSerialLabels() {
        ArrayList<Integer> serials = new ArrayList<Integer>();
        for (Component c : this.playersPanel.getComponents()) {
            if (!(c instanceof CreateGamePlayerPanel)) continue;
            CreateGamePlayerPanel playerPanel = (CreateGamePlayerPanel)c;
            PlayerSlot ps = playerPanel.getSlot();
            if (ps != null && ps.getSerial() != null) {
                serials.add(ps.getSerial());
                continue;
            }
            playerPanel.setSerialText("");
        }
        if (this.mutableSlots && !serials.isEmpty()) {
            Collections.sort(serials);
            boolean randomSeating = this.game.getSetup().getBooleanValue(Rule.RANDOM_SEATING_ORDER);
            for (Component c : this.playersPanel.getComponents()) {
                CreateGamePlayerPanel playerPanel;
                PlayerSlot ps;
                if (!(c instanceof CreateGamePlayerPanel) || (ps = (playerPanel = (CreateGamePlayerPanel)c).getSlot()) == null || ps.getSerial() == null) continue;
                String serial = randomSeating ? "?" : "" + (1 + serials.indexOf(ps.getSerial()));
                playerPanel.setSerialText(serial);
            }
        }
    }

    private void onSlotStateChange() {
        int playersAssigned = 0;
        boolean anyHumanPlayersAssigned = false;
        boolean allPlayersAssigned = true;
        for (Component c : this.playersPanel.getComponents()) {
            if (!(c instanceof CreateGamePlayerPanel)) continue;
            CreateGamePlayerPanel playerPanel = (CreateGamePlayerPanel)c;
            PlayerSlot ps = playerPanel.getSlot();
            if (ps.isOccupied()) {
                ++playersAssigned;
                if (ps.isAi()) continue;
                anyHumanPlayersAssigned = true;
                continue;
            }
            allPlayersAssigned = false;
        }
        if (this.mutableSlots) {
            if (this.gc.getChannel() == null) {
                this.startGameButton.setEnabled(playersAssigned > 0);
            } else {
                boolean state = "true".equals(System.getProperty("allowAiOnlyOnlineGame")) ? playersAssigned > 1 : anyHumanPlayersAssigned;
                this.startGameButton.setEnabled(state);
            }
        } else {
            this.startGameButton.setEnabled(allPlayersAssigned);
        }
        this.updateSerialLabels();
    }

    @Subscribe
    public void updateRule(RuleChangeEvent ev) {
        this.updateRule(ev.getRule(), ev.getValue());
    }

    @Subscribe
    public void updateExpansion(ExpansionChangedEvent ev) {
        this.updateExpansion(ev.getExpansion(), ev.getCount());
    }

    @Subscribe
    public void updateSlot(PlayerSlotChangeEvent ev) {
        this.updateSlot(ev.getSlot().getNumber());
    }

    @Subscribe
    public void updateSupportedExpansions(SupportedExpansionsChangeEvent ev) {
        this.updateSupportedExpansions(ev.getExpansions());
    }

    static class Preset
    implements Comparable<Preset> {
        private final String name;
        private Config.PresetConfig config;

        public Preset(String name, Config.PresetConfig config) {
            this.name = name;
            this.config = config;
        }

        @Override
        public int compareTo(Preset o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Config.PresetConfig getConfig() {
            return this.config;
        }

        public void setConfig(Config.PresetConfig config) {
            this.config = config;
        }
    }
}

