/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.Player;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.ui.panel.GameOverPanel;

class Playtime {
    private int hours;
    private int minutes;
    private int seconds;
    private int totalHours;
    private int totalMinutes;
    private int totalSeconds;
    private float percentage;

    Playtime(Game game, Player player, int totalRawSeconds) {
        int playerRawSeconds = GameOverPanel.getPlaytimeByPlayer(game, player);
        this.hours = playerRawSeconds / 3600;
        this.minutes = playerRawSeconds % 3600 / 60;
        this.seconds = playerRawSeconds % 60;
        this.totalHours = totalRawSeconds / 3600;
        this.totalMinutes = totalRawSeconds % 3600 / 60;
        this.totalSeconds = totalRawSeconds % 60;
        this.percentage = (float)playerRawSeconds / (float)totalRawSeconds * 100.0f;
    }

    int getHours() {
        return this.hours;
    }

    int getMinutes() {
        return this.minutes;
    }

    int getSeconds() {
        return this.seconds;
    }

    int getTotalHours() {
        return this.totalHours;
    }

    int getTotalMinutes() {
        return this.totalMinutes;
    }

    int getTotalSeconds() {
        return this.totalSeconds;
    }

    float getPercentage() {
        return this.percentage;
    }
}

