/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.component.MultiLineLabel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.panel.HelpPanel;
import com.jcloisterzone.ui.view.ConnectP2PView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class StartPanel
extends ThemedJPanel {
    static Font FONT_LARGE_BUTTON = new Font(null, 0, 25);
    private HelpPanel helpPanel;

    public StartPanel(final Client client) {
        if (!client.getTheme().isDark()) {
            this.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        }
        this.setLayout(new MigLayout("", "[center,grow]20[center,grow]", "[]20[]10[]"));
        JLabel lblNewLabel = new JLabel();
        if (client.getTheme().isDark()) {
            lblNewLabel.setIcon(new ImageIcon(StartPanel.class.getResource("/sysimages/jcloisterzone-dark.png")));
        } else {
            lblNewLabel.setIcon(new ImageIcon(StartPanel.class.getResource("/sysimages/jcloisterzone.png")));
        }
        this.add((Component)lblNewLabel, "span 2, wrap, center");
        this.helpPanel = new HelpPanel();
        this.add((Component)this.helpPanel, "span 2, wrap, grow, gap 30 30");
        ThemedJPanel playHostedPanel = new ThemedJPanel();
        if (!client.getTheme().isDark()) {
            playHostedPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        }
        this.add((Component)playHostedPanel, "grow 2, width :500:");
        playHostedPanel.setLayout(new MigLayout("", "[grow,center]", "20[40px]20[grow]"));
        playHostedPanel.add((Component)new MultiLineLabel(I18nUtils._tr("Create a new game or continue a previously saved one. A game will be hosted on your computer and other players may connect during game set up. You can also play only against any number of computer players.", new Object[0])), "wrap, grow");
        ThemedJPanel btnPanel = new ThemedJPanel();
        btnPanel.setLayout(new MigLayout("", "[]30[]30[]", "[]"));
        playHostedPanel.add((Component)btnPanel, "wrap");
        JButton btn = new JButton(I18nUtils._tr("New game", new Object[0]));
        btnPanel.add((Component)btn, "aligny top");
        btn.addActionListener(new ActionListener(){
            final /* synthetic */ StartPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                client.createGame();
            }
        });
        btn.setFont(FONT_LARGE_BUTTON);
        btnPanel.add(new ThemedJLabel(I18nUtils._tr("or", new Object[0])));
        btn = new JButton(I18nUtils._tr("Load game", new Object[0]));
        btnPanel.add((Component)btn, "aligny top");
        btn.addActionListener(new ActionListener(){
            final /* synthetic */ StartPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                client.handleLoad();
            }
        });
        btn.setFont(FONT_LARGE_BUTTON);
        playHostedPanel.add((Component)new MultiLineLabel(I18nUtils._tr("You can also connect to remote JCloisterZone application hosting a game. Connect when game is created but not yet started.", new Object[0])), "wrap, grow, gaptop 15");
        btn = new JButton(I18nUtils._tr("Connect", new Object[0]));
        playHostedPanel.add((Component)btn, "wrap, alignx center,aligny top");
        btn.addActionListener(new ActionListener(){
            final /* synthetic */ StartPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                client.mountView(new ConnectP2PView(client));
            }
        });
        btn.setFont(FONT_LARGE_BUTTON);
        ThemedJPanel playOnlinePanel = new ThemedJPanel();
        if (!client.getTheme().isDark()) {
            playOnlinePanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        }
        this.add((Component)playOnlinePanel, "grow, width :250:, wrap");
        playOnlinePanel.setLayout(new MigLayout("", "[grow,center]", "20[40px]20[grow]"));
        playOnlinePanel.add((Component)new MultiLineLabel(I18nUtils._tr("Public server is not compatible with this legacy version.", new Object[0])), "wrap, grow");
    }

    public HelpPanel getHelpPanel() {
        return this.helpPanel;
    }
}

