/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import com.jcloisterzone.ui.resources.TileImage;
import java.awt.Image;
import java.util.WeakHashMap;

public class ConvenientResourceManager
implements ResourceManager {
    private final ResourceManager manager;
    private final WeakHashMap<String, Object> imageCache = new WeakHashMap(64);

    public ConvenientResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    @Override
    public void reload() {
        this.manager.reload();
        this.imageCache.clear();
    }

    @Override
    public TileImage getTileImage(String tileId, Rotation rot) {
        String key = tileId + "@" + rot.toString();
        TileImage img = (TileImage)this.imageCache.get(key);
        if (img == null) {
            img = this.manager.getTileImage(tileId, rot);
            this.imageCache.put(key, img);
        }
        return img;
    }

    @Override
    public Image getImage(String path) {
        Image img = (Image)this.imageCache.get(path);
        if (img == null) {
            img = this.manager.getImage(path);
            this.imageCache.put(path, img);
        }
        return img;
    }

    @Override
    public Image getLayeredImage(LayeredImageDescriptor lid) {
        String key = lid.toString();
        Image img = (Image)this.imageCache.get(key);
        if (img == null) {
            img = this.manager.getLayeredImage(lid);
            this.imageCache.put(key, img);
        }
        return img;
    }

    @Override
    public ImmutablePoint getMeeplePlacement(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        return this.manager.getMeeplePlacement(effectiveTileId, tile, rot, loc);
    }

    @Override
    public ImmutablePoint getBarnPlacement() {
        return this.manager.getBarnPlacement();
    }

    @Override
    public FeatureArea getBarnArea() {
        return this.manager.getBarnArea();
    }

    @Override
    public FeatureArea getBridgeArea(Location bridgeLoc) {
        return this.manager.getBridgeArea(bridgeLoc);
    }

    @Override
    public FeatureArea getFeatureArea(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        return this.manager.getFeatureArea(effectiveTileId, tile, rot, loc);
    }
}

