/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.ImageLoader;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import com.jcloisterzone.ui.resources.TileImage;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceManager
implements ResourceManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ImageLoader imgLoader;

    public DefaultResourceManager() {
        ImageLoader imgLoader = null;
        try {
            URL defaults = this.getClass().getClassLoader().getResource("defaults/").toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{defaults});
            imgLoader = new ImageLoader(loader);
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.logger.error(e.getMessage(), e);
        }
        this.imgLoader = imgLoader;
    }

    @Override
    public void reload() {
    }

    @Override
    public TileImage getTileImage(String tileId, Rotation rot) {
        return null;
    }

    @Override
    public Image getImage(String path) {
        return this.imgLoader.getImage(path);
    }

    @Override
    public Image getLayeredImage(LayeredImageDescriptor lid) {
        return this.imgLoader.getLayeredImage(lid);
    }

    @Override
    public ImmutablePoint getBarnPlacement() {
        return ImmutablePoint.ZERO;
    }

    @Override
    public ImmutablePoint getMeeplePlacement(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        return null;
    }

    @Override
    public FeatureArea getBarnArea() {
        int rx = 500;
        int ry = 500;
        Area a = new Area(new Ellipse2D.Double(-rx, -ry, 1000.0, 1000.0));
        return new FeatureArea(a, 10).setFixed(true);
    }

    @Override
    public FeatureArea getBridgeArea(Location bridgeLoc) {
        return null;
    }

    @Override
    public FeatureArea getFeatureArea(String effectiveTileId, Tile tile, Rotation rotation, Location loc) {
        return null;
    }
}

