/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.google.common.base.CaseFormat;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.FlyingMachine;
import com.jcloisterzone.feature.Quarter;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.feature.YagaHut;

public class FeatureDescriptor {
    public static final String EVERY = "*";
    private final String tileId;
    private final Class<? extends Feature> featureType;
    private final Location location;

    public FeatureDescriptor(String tileId, Class<? extends Feature> featureType, Location location) {
        this.tileId = tileId;
        this.featureType = featureType;
        this.location = location;
    }

    private String getFeatureTypeName() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this.featureType.getSimpleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tileId).append(' ');
        sb.append(this.getFeatureTypeName()).append(' ');
        sb.append(this.location.toString());
        return sb.toString();
    }

    public static FeatureDescriptor valueOf(String descriptor) {
        String[] tokens = descriptor.split(" ");
        return FeatureDescriptor.valueOf(tokens[0], tokens[1], tokens[2]);
    }

    public static FeatureDescriptor valueOf(String tileId, String featureName, String locationName) {
        Class featureType;
        switch (featureName) {
            case "ROAD": {
                featureType = Road.class;
                break;
            }
            case "CITY": {
                featureType = City.class;
                break;
            }
            case "FARM": {
                featureType = Farm.class;
                break;
            }
            case "CLOISTER": {
                featureType = Cloister.class;
                break;
            }
            case "TOWER": {
                featureType = Tower.class;
                break;
            }
            case "CASTLE": {
                featureType = Castle.class;
                break;
            }
            case "BRIDGE": {
                featureType = Bridge.class;
                break;
            }
            case "QUARTER": {
                featureType = Quarter.class;
                break;
            }
            case "FLYING_MACHINE": {
                featureType = FlyingMachine.class;
                break;
            }
            case "YAGA_HUT": {
                featureType = YagaHut.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported feature " + featureName);
            }
        }
        Location location = Location.valueOf(locationName);
        assert (featureType == null || location.isFarmLocation() ^ !featureType.equals(Farm.class)) : "improper location " + locationName;
        return new FeatureDescriptor(tileId, featureType, location);
    }

    public String getTileId() {
        return this.tileId;
    }

    public Class<? extends Feature> getFeatureType() {
        return this.featureType;
    }

    public Location getLocation() {
        return this.location;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.featureType == null ? 1 : this.featureType.toString().hashCode());
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.tileId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureDescriptor)) {
            return false;
        }
        FeatureDescriptor other = (FeatureDescriptor)obj;
        if (this.featureType == null ? other.featureType != null : !this.featureType.equals(other.featureType)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.tileId == null ? other.tileId != null : !this.tileId.equals(other.tileId));
    }
}

