/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.legacy.FigureImageFilter;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageLoader {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;
    private static final String[] EXTENSIONS = new String[]{".jpg", ".png"};

    public ImageLoader(ClassLoader classLoader) {
        this(classLoader, "");
    }

    public ImageLoader(ClassLoader classLoader, String baseDir) {
        this.classLoader = classLoader;
    }

    private URL getResource(String relativePath) {
        return this.classLoader.getResource(relativePath);
    }

    public Image getImageResource(String path) {
        URL url = this.getResource(path);
        return url == null ? null : Toolkit.getDefaultToolkit().getImage(url);
    }

    public Image getImage(String baseName) {
        for (String ext : EXTENSIONS) {
            Image img = this.getImageResource(baseName + ext);
            if (img == null) continue;
            return new ImageIcon(img).getImage();
        }
        return null;
    }

    public Image getLayeredImage(LayeredImageDescriptor lid) {
        URL url;
        List<URL> layers = this.getResourceLayers(lid.getBaseName());
        if (layers == null) {
            return null;
        }
        if (lid.getAdditionalLayer() != null && (url = this.getResource(lid.getAdditionalLayer() + ".png")) != null) {
            layers.add(url);
        }
        return this.composeImages(layers, lid.getColorOverlay());
    }

    protected List<URL> getResourceLayers(String name) {
        URL url;
        int i = 0;
        ArrayList<URL> layers = null;
        while ((url = this.getResource(name + "_" + i + ".png")) != null) {
            if (layers == null) {
                layers = new ArrayList<URL>(4);
            }
            layers.add(url);
            ++i;
        }
        return layers;
    }

    protected Image composeImages(Iterable<URL> layers, Color colorOverlay) {
        BufferedImage result = null;
        Graphics g = null;
        FigureImageFilter colorfilter = null;
        if (colorOverlay != null) {
            colorfilter = new FigureImageFilter(colorOverlay);
        }
        for (URL layer : layers) {
            Image img = Toolkit.getDefaultToolkit().createImage(layer);
            if (colorfilter != null) {
                img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), colorfilter));
            }
            img = new ImageIcon(img).getImage();
            if (g == null) {
                result = UiUtils.newTransparentImage(img.getWidth(null), img.getHeight(null));
                g = result.createGraphics();
            }
            g.drawImage(img, 0, 0, null);
        }
        g.dispose();
        return result;
    }
}

