/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.resources.DefaultResourceManager;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import com.jcloisterzone.ui.resources.TileImage;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import java.awt.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlugableResourceManager
implements ResourceManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Iterable<Plugin> plugins;
    private Vector<ResourceManager> managers;

    public PlugableResourceManager(Iterable<Plugin> plugins) {
        this.plugins = plugins;
        this.reload();
    }

    @Override
    public void reload() {
        LinearSeq enabledPlugins = Stream.ofAll(this.plugins).filter(Plugin::isEnabled);
        enabledPlugins.forEach(Plugin::reload);
        this.managers = enabledPlugins.map(p -> p).append(new DefaultResourceManager()).toVector();
        enabledPlugins.forEach(p -> p.setParentResourceManager(this));
    }

    @Override
    public TileImage getTileImage(String tileId, Rotation rot) {
        for (ResourceManager manager : this.managers) {
            TileImage result = manager.getTileImage(tileId, rot);
            if (result == null) continue;
            return result;
        }
        this.logger.warn("Unable to load tile image for {}", (Object)tileId);
        return null;
    }

    @Override
    public Image getImage(String path) {
        for (ResourceManager manager : this.managers) {
            Image result = manager.getImage(path);
            if (result == null) continue;
            return result;
        }
        this.logger.warn("Unable to load image {}", (Object)path);
        return null;
    }

    @Override
    public Image getLayeredImage(LayeredImageDescriptor lid) {
        for (ResourceManager manager : this.managers) {
            Image result = manager.getLayeredImage(lid);
            if (result == null) continue;
            return result;
        }
        this.logger.warn("Unable to load layered image {}", (Object)lid.getBaseName());
        return null;
    }

    @Override
    public ImmutablePoint getMeeplePlacement(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        for (ResourceManager manager : this.managers) {
            ImmutablePoint result = manager.getMeeplePlacement(effectiveTileId, tile, rot, loc);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public ImmutablePoint getBarnPlacement() {
        for (ResourceManager manager : this.managers) {
            ImmutablePoint result = manager.getBarnPlacement();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public FeatureArea getBarnArea() {
        for (ResourceManager manager : this.managers) {
            FeatureArea result = manager.getBarnArea();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public FeatureArea getBridgeArea(Location bridgeLoc) {
        for (ResourceManager manager : this.managers) {
            FeatureArea result = manager.getBridgeArea(bridgeLoc);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public FeatureArea getFeatureArea(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        for (ResourceManager manager : this.managers) {
            FeatureArea result = manager.getFeatureArea(effectiveTileId, tile, rot, loc);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

